
/*
Language.h
*/

#ifndef __LANGUAGE_H
#define __LANGUAGE_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "Utils.h"

#define CMAXLONGLANGUAGE 20

#define LANG_ENGLISH 0
#define LANG_SPANISH 1
#define LANG_CATALA  2
#define LANG_EUSKERA 3
#define MAX_LANG     3
#define LANG_DEFAULT LANG_SPANISH

class Language 
  {
  private:
    int LANGUAGE;
    char stLANGUAGE[CMAXLONGLANGUAGE + 1], stlLANGUAGE[CMAXLONGLANGUAGE + 1];
    const char *getStringEnglish (int WHAT);
    const char *getStringSpanish (int WHAT);    
    const char *getStringCatala  (int WHAT); 
    const char *getStringEuskera  (int WHAT);       
    const char *getPageEnglish (int WHAT);
    const char *getPageSpanish (int WHAT);    
    const char *getPageCatala  (int WHAT);  
    const char *getPageEuskera  (int WHAT);          
  public:
    Language (int aLANGUAGE);
    Language (const char *pcLANGUAGE); 
    virtual ~Language();
    void setLang (const char *pcLANGUAGE);
    int getLang (void);    
    const char *getStLang (void);
    const char *get  (int WHAT);   
    const char *getDescriptionLanguage (int WHAT);
    const char *getPage (int WHAT);
  };

//*******************************************************
//MSG_ begin in 1  
//*******************************************************
#define MSG_CONNREFUSED              1
#define MSG_CANRECONNECTHERE         2
#define MSG_SERVERISDOWN             3
#define MSG_PERHAPSTIMEOUT           4
#define MSG_CONF_DELETEMAILBOX       5
#define MSG_CONF_EXPUNGE             6
#define MSG_CONF_LOGOUT              7
#define MSG_SEND_OK                  8
#define MSG_SEND_ERR                 9
#define MSG_SAVED_SENTMAIL           10
#define MSG_CANCELMSG                14
#define MSG_SHOWOPTIONS              15
#define MSG_SAVEOPTIONS              16
#define MSG_CANCEL                   17
#define MSG_ADDBOOK                  18
#define MSG_SAVEADDBOOK              19
#define MSG_ERR_SAVEOPTIONS          21
#define MSG_ERR_SAVEADDBOOK          22
#define MSG_MSGSPURGED               23
#define MSG_MSGSPURGED_S             24
#define MSG_MSGSPURGED_0             25
#define MSG_MAILBOXCHANGED           26
#define MSG_MAILBOXCREATED           27
#define MSG_MAILBOXDELETED           28
#define MSG_MAILBOXRENAMED           29
#define MSG_MOVEDMESSAGES            30
#define MSG_MOVEDMESSAGES_S          31
#define MSG_COPYMESSAGES             32
#define MSG_COPYMESSAGES_S           33
#define MSG_INVALIDPAGE              34
#define MSG_SHOWATTACHS              35
#define MSG_SAVEATTACHS              36
#define MSG_ERASEATTACHS             37
#define MSG_ERR_SAVEATTACHS          38
#define MSG_AB_EDITENTRY             39
#define MSG_AB_SAVEENTRY             40
#define MSG_AB_DELEENTRY             41
#define MSG_AB_ADDTO                 42
#define MSG_AB_ADDCC                 43
#define MSG_AB_ADDBCC                44            
#define MSG_NO_ENTRIES_MARKED        45
#define MSG_FLAGS_CHANGED            46
#define MSG_FLAGS_CHANGED_S          47
#define MSG_FIELD_TO_EMPTY           48
#define MSG_FIELD_SUBJ_EMPTY         49      
#define MSG_COMPOSE_TIMEOUT          50
#define MSG_TOO_MAX_CONN             51
#define MSG_ERR_SAVE_SENTMAIL        52
#define MSG_TOO_MAX_TRY_CONN         53
#define MSG_ADDRESS_LINE_CUT         54
#define MSG_MIN_TIMEBETWCONNS        55
#define MSG_ERR_RELOAD_ATTACHS       56
#define MSG_NOATTACHSERASED          57
#define MSG_NOATTACHSSAVED           58
#define MSG_NO_ELEMENTS              59
#define MSG_BADCOOKIE                60
#define MSG_DEBUG                    61
#define MSG_MALFORMED_MESSAGE        62
#define MSG_MSGSFOUND                63
#define MSG_MSGSFOUND_S              64
#define MSG_MSGSFOUND_0              65
#define MSG_MSGS_SORTED              66
#define MSG_GO_TO_DISABLED           67
#define MSG_AB_ADDFIELDS             68
#define MSG_NNTP_SEND_WARNING        69
#define MSG_MANAGE_NNTPGROUPS        70
#define MSG_NNTPGROUPS_FOUND         71
#define MSG_NNTPGROUPS_ADDED         72
#define MSG_MAX_NNTPGROUPS_FOUND     73
#define MSG_NEW_TO_FORUMS            74
#define MSG_INVALIDCOMMAND           75
#define MSG_CHANGEPW_OK              76
#define MSG_CONF_DELETEITEMS         77
#define MSG_FILESDELETED             78
#define MSG_FILESDELETED_S           79
#define MSG_FILESCOPY                80
#define MSG_FILESCUT                 81
#define MSG_FILESPASTED              82
#define MSG_FILERENAMED_OK           83
#define MSG_FILESAVED_OK             84
#define MSG_FILESORT_OK              85
#define MSG_FILECREATED_OK           86
#define MSG_DISKCHANGED_OK           87
#define MSG_NEED_PASSWORD_SERVICE    88
#define MSG_NEWMSGS_0                89
#define MSG_NEWMSGS_1                90
#define MSG_NEWMSGS_n                91
#define MSG_RECONNECT_NOTALLOWED     92
#define MSG_RECORDSDELETED           94
#define MSG_RECORDSDELETED_S         95
#define MSG_RECORDSPURGED            96
#define MSG_RECORDSPURGED_S          97 
#define MSG_RECORDSPURGED_0          98
#define MSG_CONF_DBEXPUNGE           99
#define MSG_RECORDSFOUND            100 
#define MSG_RECORDSFOUND_S          101 
#define MSG_RECORDSFOUND_0          102
#define MSG_CONF_DBDELETE           103
#define MSG_RECORDS_ALL_SHOWN       104
#define MSG_SHOWOPTIONS_CCLIENT     105
#define MSG_SHOWOPTIONS_NNTP        106
#define MSG_SHOWOPTIONS_APPEARANCE  107
#define MSG_CONF_FILTERSDELETE      108
#define MSG_INSERTSPAMFILTER        109
#define MSG_CONFDELETEEVENT         110
#define MSG_CONF_CLEARMAILBOX       111
#define MSG_INSERTSPAMFILTER2       112

//*******************************************************
//ERR_ begin in 1000  
//*******************************************************
#define ERR_INV_CMD                  1000
#define ERR_INV_USER_PW              1001
#define ERR_INV_MAILBOX              1002
#define ERR_INV_PARMS                1003
#define ERR_OPENCONN                 1004
#define ERR_CREAT_USERDIR            1005
#define ERR_CREAT_USERATTACHSDIR     1006
#define ERR_SENDING_MSG              1007    
#define ERR_AB_DELEENTRY             1008
#define ERR_MAXSIZEATT               1009
#define ERR_UNHANDLESIZEATTACH       1010
#define ERR_QUOTA_USAGE              1011
#define ERR_SERVERISDOWN             1012
#define ERR_UUDECODING               1013
#define ERR_NNTP_NUM_SEL             1014
#define ERR_INV_SERVICE              1015
#define ERR_SERVICE_NOTALLOWED       1016
#define ERR_FILE_EXISTS              1017
#define ERR_FILE_INVALIDNAME         1018
#define ERR_FILE_NO_EXISTS           1019
#define ERR_FILE_CREATE              1020
#define ERR_FILE_WRITING             1021
#define ERR_DIR_EXISTS               1022
#define ERR_DIR_CREATE               1023
#define ERR_DIR_OPEN                 1024
#define ERR_FILE_DELETING            1025
#define ERR_MAXSIZEFILEUPLOAD        1026
#define ERR_CLIPBOARD_EMPTY          1027
#define ERR_SELECT_MORE_ONE          1028
#define ERR_FILE_RENAMING            1029
#define ERR_FILE_COPYING             1030
#define ERR_FILE_MOVING              1031
#define ERR_FILE_MOV_SAMESITE        1032
#define ERR_QUOTA_OVER               1033
#define ERR_SERVICE_INITIALIZING     1034
#define ERR_CREAT_USERDATABASESDIR   1035
#define ERR_FILTERALREADYEXISTS      1036
#define ERR_ISOPEN_MAILBOX           1037

//*******************************************************
//ALT_ begin in 2000  
//*******************************************************
#define ALT_LOGO                     2000
#define ALT_PREVPAGE_ACT             2001
#define ALT_PREVPAGE_INA             2002
#define ALT_NEXTPAGE_ACT             2003
#define ALT_NEXTPAGE_INA             2004
#define ALT_FIRSTPAGE_ACT            2005
#define ALT_FIRSTPAGE_INA            2006
#define ALT_LASTPAGE_ACT             2007
#define ALT_LASTPAGE_INA             2008
#define ALT_DUMPFULLMSG              2009
#define ALT_NEXTMSG                  2010
#define ALT_PREVMSG                  2011
#define ALT_NEXTMSG_INA              2012
#define ALT_PREVMSG_INA              2013
#define ALT_LOGOUT                   2014
#define ALT_EXPUNGE                  2015
#define ALT_HELP                     2016
#define ALT_COMPOSEMSG               2017
#define ALT_MAILBOXES                2018
#define ALT_REPLYMSG                 2019
#define ALT_FORWARDMSG               2020
#define ALT_SHOWOPTIONS              2022
#define ALT_ADDBOOK                  2023
#define ALT_BACK                     2024
#define ALT_SAVEADDRESS              2025
#define ALT_SORT                     2026
#define ALT_AB_NEWENTRY              2027
#define ALT_DELNEXTMSG               2028
#define ALT_ABOUT                    2029
#define ALT_UNDELNEXTMSG             2030
#define ALT_AB_DUMP                  2031
#define ALT_DUMPFULLHEADER           2032
#define ALT_AB_NEWENTRY_S            2033
#define ALT_AB_DUMP_S                2034
#define ALT_REPLYALLMSG              2035
#define ALT_SENDTONNTPGROUP          2036
#define ALT_COMPOSEMSGNNTP           2037
#define ALT_ROOT                     2038
#define ALT_MAIL                     2039
#define ALT_NNTP                     2040
#define ALT_POPPASS                  2041
#define ALT_FILEBROWSER              2042
#define ALT_FINGER                   2043
#define ALT_FORWARDMAIL              2044
#define ALT_SECVIRTUAL               2045
#define ALT_UPSORT                   2046
#define ALT_DOWNSORT                 2047
#define ALT_DATABASES                2048
#define ALT_NEXTRECORD               2049
#define ALT_PREVRECORD               2050
#define ALT_PREV                     2051
#define ALT_NEXT                     2052

//*******************************************************
//TIT_ begin in 3000  
//*******************************************************
#define TIT_COMPOSEMSG               3000
#define TIT_HOMEPAGE                 3001
#define TIT_CONFIRMACTION            3002
#define TIT_INDEXMAILBOX             3003
#define TIT_MAILBOXES                3004
#define TIT_MESSAGEHEADER            3005 
#define TIT_REPLYMSG                 3006
#define TIT_FORWARDMSG               3007
#define TIT_SHOWOPTIONS              3009
#define TIT_ADDBOOK                  3010
#define TIT_INVALIDPAGE              3011
#define TIT_SHOWATTACHS              3012
#define TIT_BADCOOKIE                3013
#define TIT_SHOWHEADERS              3014
#define TIT_REPLYALLMSG              3015
#define TIT_REPLYGROUP               3016
#define TIT_COMPOSEMSGNNTP           3017
#define TIT_SHOWNNTPMANAGEGROUPS     3018
#define TIT_INVALIDCOMMAND           3019
#define TIT_SERVICES                 3020
#define TIT_POPPASS_DISPLAYPAGE      3021
#define TIT_FINGER_DISPLAYPAGE       3022
#define TIT_FILEBROWSER_DISPLAYPAGE  3023
#define TIT_FILEBROWSER_EDITFILEPAGE 3024
#define TIT_FORWARDMAIL_DISPLAYPAGE  3025
#define TIT_DATABASES_EDITRECORD     3026
#define TIT_DATABASES_INDEXPAGE      3027 
#define TIT_DATABASES_DISPLAYRECORD  3028 
#define TIT_DATABASES_MAINPAGE       3029 
#define TIT_DATABASES_DB_DEFINE      3030
#define TIT_SIEVE_DISPLAYPAGE        3031
#define TIT_CALENDAR_DISPLAYPAGE     3032

//*******************************************************
//L_ begin in 4000  
//*******************************************************
#define L_ATTACHSHOWED               4000
#define L_USER                       4001
#define L_PASSWORD                   4002 
#define L_LOGIN                      4003
#define L_CLEAR                      4004
#define L_LOGOUT                     4005
#define L_INDEXMAILBOX               4006
#define L_CHOOSELANGUAGE             4007
#define L_COPYRIGHT                  4008
#define L_MESSAGES                   4009
#define L_PREVPAGE_ACT               4010
#define L_PREVPAGE_INA               4011
#define L_NEXTPAGE_ACT               4012
#define L_NEXTPAGE_INA               4013
#define L_FIRSTPAGE_ACT              4014
#define L_FIRSTPAGE_INA              4015
#define L_LASTPAGE_ACT               4016
#define L_LASTPAGE_INA               4017
#define L_MESSAGE                    4018
#define L_INDEXMAILBOX2              4019
#define L_MESSAGE2                   4020
#define L_DUMPFULLMSG                4021
#define L_NOSUBJECT                  4022
#define L_NEXTMSG                    4023
#define L_NEXTMSG_INA                4024
#define L_PREVMSG                    4025
#define L_PREVMSG_INA                4026
#define L_ERROR                      4027
#define L_STRUCTMIME                 4028
#define L_EXECUTE                    4029
#define L_DELETED                    4030
#define L_EXPUNGE                    4031
#define L_UNDELETED                  4032
#define L_HELP                       4033
#define L_COMPOSEMSG                 4034
#define L_MAILBOXES                  4035
#define L_CHANGEMAILBOX              4036
#define L_CREATEMAILBOX              4037
#define L_DELETEMAILBOX              4038
#define L_RENAMEMAILBOX              4039
#define L_ANSWEREDMSG                4040
#define L_UNANSWEREDMSG              4041
#define L_FLAGGEDMSG                 4042
#define L_UNFLAGGEDMSG               4043
#define L_SEENMSG                    4044
#define L_UNSEENMSG                  4045
#define L_MOVEMSG                    4048
#define L_COPYMSG                    4049
#define L_CANCEL                     4050
#define L_CONFIRM                    4051
#define L_TO                         4052
#define L_CC                         4053
#define L_BCC                        4054
#define L_SUBJECT                    4055
#define L_TEXTTOSEND                 4056
#define L_CANCELMSG                  4057
#define L_SENDMSG                    4058
#define L_ATTACHMSG                  4059
#define L_REPLYMSG                   4060
#define L_FORWARDMSG                 4061
#define L_FROM                       4062
#define L_DATE                       4063
#define L_REPLYTO                    4064
#define L_SHOWOPTIONS                4066
#define L_ADDBOOK                    4067
#define L_SAVE                       4068
#define L_MSGSPERINDEXPAGE           4069
#define L_INSIGNINNEWMSG             4070
#define L_PERSONALNAME               4071
#define L_NOFROM                     4072
#define L_SIGNATURE                  4073
#define L_SAVEMSGSENTMAIL            4074
#define L_ATTACH_NEW                 4075
#define L_FILE                       4076
#define L_NO_ATTACHS                 4077
#define L_DOATTACH                   4078
#define L_DETACH                     4079
#define L_AB_NICKNAME                4080
#define L_AB_FULLNAME                4081
#define L_AB_ADDRESSES               4082
#define L_AB_FCC                     4083
#define L_AB_COMMENTS                4084
#define L_AB_EDITENTRY               4085
#define L_AB_NEWENTRY                4086
#define L_DELETE                     4087
#define L_NUMOFENTRIES               4088
#define L_BACK                       4089
#define L_CLEANALL                   4090
#define L_SAVEADDRESS                4091
#define L_NUMBER                     4092
#define L_FLAGS                      4093
#define L_SIZE                       4094
#define L_FLAG_DELETED               4095
#define L_FLAG_ANSWERED              4096
#define L_FLAG_FLAGGED               4097
#define L_FLAG_NEW                   4098
#define L_FLAG_UNSEEN                4099
#define L_MARK                       4100
#define L_MSGS_AS                    4101
#define L_PRESS_TO_INDEX             4102
#define L_EDIT                       4103
#define L_SORT                       4104
#define L_MSGS_SHOWN                 4105
#define L_INDEXMAILBOX3              4106
#define L_LEX_TO                     4107
#define L_DELNEXTMSG                 4108
#define L_ABOUT                      4109
#define L_REPLYFROM                  4110
#define L_FORWATTACHS                4111
#define L_SIZEWRITEAREA              4112
#define L_UNDELNEXTMSG               4113
#define L_NEXTMSGSHOWN               4114
#define L_LASTMSGSHOWN               4115
#define L_NUMATTACHSHOW              4116
#define L_INDEXMAILBOX4              4117
#define L_DOWNLOADMAILBOX            4118
#define L_EMPTY_IMAPSERVER           4119
#define L_NOTALLOWED_IMAPSERVER      4120
#define L_AB_DUMP                    4121
#define L_TRUNCATELENGTHREADINGMSG   4122
#define L_SKIN                       4123
#define L_SECURITYPROBLEM            4124
#define L_REFRESH                    4125
#define L_FLAG_SEARCHED              4126
#define L_SEARCH                     4127
#define L_REFRESHTIME                4128
#define L_SEARCH_SUBJECT             4129
#define L_SEARCH_FROM                4130
#define L_SEARCH_BODY                4131
#define L_SEARCH_ALL                 4132
#define L_CONFIRMPURGE               4133
#define L_CONFIRMLOGOUT              4134
#define L_FLAG_UNDELETED             4135
#define L_FLAG_UNANSWERED            4136
#define L_FLAG_UNFLAGGED             4137
#define L_FLAG_UNNEW                 4138
#define L_FLAG_SEEN                  4139
#define L_FLAG_UNSEARCHED            4140
#define L_SEARCHEDMSG                4141
#define L_UNSEARCHEDMSG              4142
#define L_DUMPFULLHEADER             4143
#define L_ADDADDRESS_TO              4144
#define L_ADDADDRESS_CC              4145
#define L_ADDADDRESS_BCC             4146
#define L_DELADDRESSES               4147
#define L_TO0                        4148
#define L_CC0                        4149
#define L_BCC0                       4150
#define L_ADDADDRESS_FIELD           4151
#define L_AB_NEWENTRY_S              4152
#define L_AB_DUMP_S                  4153
#define L_REPLYALLMSG                4154
#define L_NNTPGROUP                  4155
#define L_SENDTONNTPGROUP            4156
#define L_COMPOSEMSGNNTP             4157
#define L_NNTPSERVER                 4158
#define L_SUBSCRIBEDGROUPS           4159
#define L_MANAGE_NNTPGROUPS          4160
#define L_LIST_EMPTY                 4161
#define L_NNTP_LISTSEARCH            4162
#define L_GROUPSTOADD                4163
#define L_ADDSELECTEDGROUPS          4164
#define L_DUMPFULLLIST               4165
#define L_FORCEDGROUPS               4166
#define L_DISPLAY_UUENCODED          4167
#define L_GOSELECTEDGROUP            4168
#define L_OP_SHOWCLOCK               4169
#define L_ADD_MORE_FORUMS            4170
#define L_SORTBYTHREADS              4171
#define L_CHANGEPASSWORD             4172
#define L_PASSWORD_OLD               4173
#define L_PASSWORD_NEW1              4174
#define L_PASSWORD_NEW2              4175
#define L_PRESS_TO_ROOTPAGE          4176
#define L_FINGER                     4177
#define L_FILEBROWSER                4178
#define L_FOLDER                     4179
#define L_PARENTFOLDER               4180
#define L_CURRENTFOLDER              4181
#define L_CREATE                     4182
#define L_COPY                       4183
#define L_CUT                        4184
#define L_PASTE                      4185
#define L_LOAD                       4186
#define L_RENAME                     4187
#define L_ROOT                       4188
#define L_MAIL                       4189
#define L_NNTP                       4190
#define L_POPPASS                    4191
#define L_FORWARDMAIL                4192
#define L_CURRENTFORWARDS            4193
#define L_FORWARD_ERASE              4194
#define L_QUOTAUSAGE                 4195
#define L_RENAME_TO                  4196
#define L_CURRENTDISK                4197
#define L_CHANGE_DISK                4198                           
#define L_FOLDER_COPY                4199
#define L_FOLDER_CUT                 4200
#define L_FILE_COPY                  4201
#define L_FILE_CUT                   4202                
#define L_TOTAL_SIZE                 4203
#define L_SECVIRTUAL                 4204
#define L_UPSORT                     4205
#define L_DOWNSORT                   4206
#define L_SERVICE                    4207
#define L_MAIL_DESCRIPTION           4208
#define L_FILEBROWSER_DESCRIPTION    4209
#define L_FINGER_DESCRIPTION         4210
#define L_FORWARDMAIL_DESCRIPTION    4211
#define L_MAIN_DESCRIPTION           4212
#define L_POPPASS_DESCRIPTION        4213
#define L_SECVIRTUAL_DESCRIPTION     4214
#define L_MAIN                       4215
#define L_SYNC                       4216
#define L_DATABASES                  4217
#define L_DATABASES_DESCRIPTION      4218
#define L_DISPLAY                    4219
#define L_UNDELETE                   4220
#define L_FLAG_COPIED                4221
#define L_FLAG_UNCOPIED              4222
#define L_DB_INDEXHEADER             4223
#define L_DB_CHANGE                  4224
#define L_DUMP                       4225
#define L_DB_MYNEWDB                 4226
#define L_LEX_AS                     4227
#define L_IMPORT                     4228
#define L_EXPORT                     4229
#define L_LEX_OF                     4230
#define L_NONE_A                     4231
#define L_DEFINE                     4232
#define L_FIELD_ADD                  4233
#define L_FIELD_DEL                  4234
#define L_DATABASE                   4235 
#define L_FIELD_NAME                 4236
#define L_FIELD_ORDER                4237
#define L_FIELD_TYPE                 4238
#define L_FIELD_MAXLENGTH            4239
#define L_FIELD_DISPLAYLENGTH        4240
#define L_FIELD_INDEXLENGTH          4241
#define L_FIELD_LABEL                4242
#define L_FIELD_DEFAULT              4243
#define L_FIELD_COULDBENULL          4244
#define L_FIELD_OPTIONAL1            4245
#define L_FIELD_OPTIONAL2            4246
#define L_FIELD_OPTIONAL3            4247
#define L_FIELD_OPTIONAL4            4248
#define L_DELETESEARCH               4249
#define L_DISPLAYPERSONALINFO        4250
#define L_USERACCOUNTS               4251
#define L_USERACCOUNTS_DESCRIPTION   4252
#define L_CONFIG                     4253
#define L_CONFIG_DESCRIPTION         4254
#define L_CONFIG_CCLIENT             4255
#define L_CONFIG_NNTP                4256
#define L_CONFIG_APPEARANCE          4257
#define L_APPEARANCE                 4258
#define L_SIEVE                      4259
#define L_SIEVE_DESCRIPTION          4260
#define L_FILTERS                    4261
#define L_NAME                       4262
#define L_LEX_THEN                   4263   
#define L_SIEVE_IF_IN_THE_MAIL       4264
#define L_VACATION                   4265 
#define L_VACATION_TEXT              4266
#define L_VACATION_DAYS2REPEAT       4267
#define L_VACATION_ADDRESSES         4268
#define L_ACTIVED                    4269
#define L_UNACTIVED                  4270
#define L_REJECT                     4271
#define L_REJECTEDTEXT               4272
#define L_TO_CONTAINS                4273
#define L_FROM_CONTAINS              4274
#define L_SUBJECT_CONTAINS           4275
#define L_SIZE_IS_OVER               4276
#define L_HEADER_CONTAINS            4277
#define L_CONTAINS                   4278
#define L_VACATION_ADD_EXPLICAT      4279
#define L_UP                         4280
#define L_DOWN                       4281
#define L_OP_SHOWICONSLABELS         4282
#define L_ICONSSIZE                  4283
#define L_SMALL                      4284
#define L_BIG                        4285
#define L_MEDIUM                     4286
#define L_INSERTSPAWNFILTER          4287
#define L_SERVICEPW_INCORRECT        4288
#define L_CALENDAR                   4289 
#define L_CALENDAR_DESCRIPTION       4290
#define L_CHANGE                     4291
#define L_WEEK                       4292
#define L_TODAY                      4293
#define L_HOUR                       4294
#define L_TITLE                      4295
#define L_DESCRIPTION                4296
#define L_STATUS                     4297
#define L_STATUS_FINISHED            4298
#define L_STATUS_OPEN                4299
#define L_STATUS_DELAYED             4300
#define L_PRIORITY                   4301
#define L_PRIORITY_LOW               4302
#define L_PRIORITY_CURRENT           4303
#define L_PRIORITY_IMPORTANT         4304
#define L_PRIORITY_VERYIMPORTANT     4305
#define L_TYPE                       4306
#define L_TYPE_CELEBRATION           4307
#define L_TYPE_MEETING               4308
#define L_TYPE_LAUNCH                4309
#define L_TYPE_OTHER                 4310
#define L_ADD                        4311
#define L_YESTERDAY                  4312
#define L_TOMORROW                   4313
#define L_YEAR                       4314
#define L_DAY                        4315
#define L_LEX_SINCE                  4316
#define L_INSERTSPAWNFILTER2         4317
#define L_CLEARMAILBOX               4318
#define L_CREATEFILTER               4319
#define L_DOTLEARN                   4320
#define L_DOTLEARN_DESCRIPTION       4321
#define L_MODERATORS                 4322

//*******************************************************
//IMG_ begin in 5000  
//*******************************************************
#define IMG_LOGO                     5000
#define IMG_FLAG_DELETED             5001
#define IMG_FLAG_ANSWERED            5002
#define IMG_FLAG_FLAGGED             5003
#define IMG_FLAG_UNSEEN              5004
#define IMG_FLAG_SEARCHED            5005
#define IMG_FLAG_UNDELETED           5006
#define IMG_FLAG_UNANSWERED          5007
#define IMG_FLAG_UNFLAGGED           5008
#define IMG_FLAG_SEEN                5009
#define IMG_FLAG_UNSEARCHED          5010
#define IMG_FLAG_COPIED              5011
#define IMG_FLAG_UNCOPIED            5012
#define IMG_LEFT_ARROW               5013
#define IMG_RIGHT_ARROW              5014

//*******************************************************
//others begin in 10000  
//*******************************************************
#define PREFIX_REPLY                 10000
#define PREFIX_FORWARD               10001
#define FORWARDLINE                  10002

#endif











