/*
 *  $Id: values.c,v 1.1 2000/12/23 12:56:30 fenrus Exp $
 *	This file is part of Powertweak Linux.
 *	(C) 2000 Dave Jones, Arjan van de Ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>


#include <powertweak.h>


void copy_values(value_t *dest,value_t src)
{	
	assert(dest!=NULL);
	if (dest->strVal!=NULL) 
		free(dest->strVal);
	if (src.strVal!=NULL)
		dest->strVal = strdup(src.strVal);
	else
		dest->strVal = NULL;
	dest->intVal = src.intVal;
}

void copy_and_release_value(value_t *dest,value_t *src)
{	
	assert(dest!=NULL);
	if (dest->strVal!=NULL) 
		free(dest->strVal);
	if (src->strVal!=NULL) {
		dest->strVal = src->strVal;
		src->strVal = NULL;
	} else {
		dest->strVal = NULL;
		free(src->strVal);
		src->strVal = NULL;
	}
	dest->intVal = src->intVal;
}


void release_value(value_t *val)
{
	if (val->strVal!=NULL) {
		free(val->strVal);
		val->strVal = NULL;
	}
}
