/*
 * this code is inspired from the NIDSfindshellcode program by
 * Fermin J. Serna <fjserna@ngsec.com>.
 *
 * Here is what this rew-write provide you compared to the original code:
 *
 * - serialized all architecture test within the same buffer walking loop.
 *   was 3 * O(n * m) and is now 1 * O(n * m).
 *
 * - use an hash table for pointing to opcode we are now O(n lg m).
 *
 */

#ifndef SHELLCODE_H
#define SHELLCODE_H

#define IA32_JUNKS 79
#define SPARC_JUNKS  21
#define HPPA_JUNKS 11

struct junks {
        char *code;          /* the operation code */
        size_t len;          /* length of code */
        int noppad;          /* can we use it for NOP pad? */
        int morph;           /* can we use it for morph pad? */
        int upper;           /* can we use through toupper()? */
        int lower;           /* can we use through tolower()? */
        int dyn;             /* is the instruction dynamic? */
        int dynint;          /* where is the dynamic byte? */
        int weight;          /* weight of this code to appear in output 1 == low, > 1 is higher :) */
};



struct junks intel_njunk[IA32_JUNKS] = {
        /* these may be dangerious depending on your sploit */
        { "\x50",1,1,0,1,0,0,0,1 },         /* push %eax  "P" */
        { "\x51",1,1,0,1,0,0,0,1 },         /* push %ecx  "Q" */
        { "\x52",1,1,0,1,0,0,0,1 },         /* push %edx  "R" */
        { "\x53",1,1,0,1,0,0,0,1 },         /* push %ebx  "S" */
        { "\x54",1,1,0,1,0,0,0,1 },         /* push %dsp  "T" */
        { "\x55",1,1,0,1,0,0,0,1 },         /* push %ebp  "U" */
        { "\x56",1,1,0,1,0,0,0,1 },         /* push %esi  "V" */
        { "\x57",1,1,0,1,0,0,0,1 },         /* push %edi  "W" */
        { "\x58",1,1,0,1,0,0,0,1 },         /* pop %eax   "X" */
        { "\x59",1,1,0,1,0,0,0,1 },         /* pop %ecx   "Y" */
        { "\x5a",1,1,0,1,0,0,0,1 },         /* pop %edx   "Z" */
        { "\x5b",1,1,0,1,1,0,0,1 },         /* pop %ebx   "[" */
        { "\x5d",1,1,0,1,1,0,0,1 },         /* pop %ebp   "]" */
        { "\x5e",1,1,0,1,1,0,0,1 },         /* pop %esi   "^" */
        { "\x5f",1,1,0,1,1,0,0,1 },         /* pop %edi   "_" */
        { "\x60",1,1,0,1,1,0,0,1 },         /* pusha      "`" */
        { "\x9b",1,1,1,1,1,0,0,1 },         /* fwait          */
        { "\x9c",1,1,1,1,1,0,0,1 },         /* pushf          */
        { "\x9e",1,1,1,1,1,0,0,1 },         /* safh           */
        /* dangerious opcodes section over */
        { "\x99",1,1,1,1,1,0,0,1 },         /* cltd           */
        { "\x96",1,1,0,1,1,0,0,1 },         /* xchg %eax,%esi */
        { "\x97",1,1,0,1,1,0,0,1 },         /* xchg %eax,%edi */
        { "\x95",1,1,0,1,1,0,0,1 },         /* xchg %eax,%ebp */
        { "\x93",1,1,0,1,1,0,0,1 },         /* xchg %eax,%ebx */
        { "\x91",1,1,0,1,1,0,0,1 },         /* xchg %eax,%ecx */
        { "\x90",1,1,1,1,1,0,0,1 },         /* regular NOP    */
        { "\xc1\xe8\x42",3,0,1,1,1,1,2,1 }, /* shr N,%eax     */
        { "\x4d",1,1,0,1,0,0,0,1 },         /* dec %ebp,  "M" */
        { "\x6b\xc0\x42",3,0,1,1,1,1,2,1 }, /* imul N,%eax    */
        { "\x48",1,1,1,1,0,0,0,1 },         /* dec %eax,  "H" */
        { "\x33\xc0",2,0,1,1,1,0,0,1 },     /* xor %eax,%eax  */
        { "\x47",1,1,1,1,0,0,0,1 },         /* inc %edi   "G" */
        { "\x4f",1,1,1,1,0,0,0,1 },         /* dec %edi   "O" */
        { "\x40",1,1,1,1,1,0,0,1 },         /* inc %eax   "@" */
        { "\x8c\xc0",2,0,1,1,1,0,0,1 },     /* mov %es,%eax   */
        { "\x41",1,1,0,1,0,0,0,1 },         /* inc %ecx   "A" */
        { "\x37",1,1,1,1,1,0,0,1 },         /* aaa        "7" */
        { "\x3f",1,1,1,1,1,0,0,1 },         /* aas        "?" */
        { "\x97",1,1,1,1,1,0,0,1 },         /* xchg %eax,%edi */
        { "\x46",1,1,0,1,0,0,0,1 },         /* inc %esi   "F" */
        { "\x4e",1,1,0,1,0,0,0,1 },         /* dec %esi   "N" */
        { "\xf8",1,1,1,1,1,0,0,1 },         /* clc            */
        { "\x92",1,1,1,1,1,0,0,1 },         /* xchg %eax,%edx */
        { "\xfc",1,1,1,1,1,0,0,1 },         /* cld            */
        { "\x87\xdb",2,0,1,1,1,0,0,1 },     /* xchg %ebx,%ebx */
        { "\x98",1,1,1,1,1,0,0,1 },         /* cwtl           */
        { "\x27",1,1,1,1,1,0,0,1 },         /* daa        "'" */
        { "\x87\xc9",2,0,1,1,1,0,0,1 },     /* xchg %ecx,%ecx */
        { "\x2f",1,1,1,1,1,0,0,1 },         /* das        "/" */
        { "\x9f",1,1,1,1,1,0,0,1 },         /* lahf           */
        { "\x87\xd2",2,0,1,1,1,0,0,1 },     /* xchg %edx,%edx */
        { "\xf9",1,1,1,1,1,0,0,1 },         /* stc            */
        { "\x83\xf0\x42",3,0,1,1,1,1,2,1 }, /* xor N,%eax     */
        { "\x4a",1,1,0,1,0,0,0,1 },         /* dec %edx   "J" */
        { "\x8c\xe0",2,0,1,1,1,0,0,1 },     /* mov %fs,%eax   */
        { "\x44",1,1,0,1,0,0,0,1 },         /* inc %esp   "D" */
        { "\xc1\xc0\x42",3,0,1,1,1,1,2,1 }, /* rol N,%eax     */
        { "\x42",1,1,0,1,0,0,0,1 },         /* inc %edx   "B" */
        { "\x83\xfb\x42",3,0,0,1,1,1,2,1 }, /* cmp N,%ebx     */
        { "\x85\xc0",2,0,1,1,1,0,0,1 },     /* test %eax,%eax */
        { "\xc1\xc8\x42",3,0,1,1,1,1,2,1 }, /* ror N,%eax     */
        { "\x43",1,1,0,1,0,0,0,1 },         /* inc %ebx   "C" */
        { "\x83\xc8\x42",3,0,1,1,1,1,2,1 }, /* or  N,%eax     */
        { "\x49",1,1,0,1,0,0,0,1 },         /* dec %ecx   "I" */
        { "\x83\xe8\x42",3,0,1,1,1,1,2,1 }, /* sub N,%eax     */
        { "\x4b",1,1,0,1,0,0,0,1 },         /* dec %ebx   "K" */
        { "\x83\xfa\x42",3,0,0,1,1,1,2,1 }, /* cmp N,%edx     */
        { "\xf7\xd0",2,0,1,1,1,0,0,1 },     /* not %eax       */
        { "\x83\xf9\x42",3,0,0,1,1,1,2,1 }, /* cmp N,%ecx     */
        { "\xf7\xd0",2,0,1,1,1,0,0,1 },     /* not %eax       */
        { "\x83\xf9\x42",3,0,0,1,1,1,2,1 }, /* cmp N,%ecx     */
        { "\x8c\xe8",2,0,1,1,1,0,0,1 },     /* mov %gs,%eax   */
        { "\xf5",1,1,1,1,1,0,0,1 },         /* cmc            */
        { "\x83\xe0\x42",3,0,1,1,1,1,2,1 }, /* and N,%eax     */
        { "\xb0\x42",2,0,1,1,1,1,1,1 },     /* mov N,%eax     */
        { "\x45",1,1,0,1,0,0,0,1 },         /* inc %ebp   "E" */
        { "\x83\xf8\x42",3,0,1,1,1,1,2,1 }, /* cmp N,%eax     */
        { "\x4c",1,1,0,1,0,0,0,1 },         /* dec %esp   "L" */
        { "\x83\xc0\x42",3,0,1,1,1,1,2,1 }  /* add N,%eax,    */
};

struct junks sparc_njunk[SPARC_JUNKS] = {
        { "\xa2\x1c\x80\x12",4,1,1,1,1,0,0,1 },      /* xor %l2,%l2,%l1   */
        { "\xb6\x06\x40\x1a",4,1,1,1,1,0,0,1 },      /* add %i1,%i2,%i3   */
        { "\xa0\x26\xe0\x42",4,1,1,1,1,1,3,1 },      /* sub %i3,0x42,%l0  */
        { "\xb6\x16\x40\x1a",4,1,1,1,1,0,0,1 },      /* or  %i1,%i2,%i3   */
        { "\xb2\x03\x60\x42",4,1,1,1,1,1,3,1 },      /* add %o5,0x42,%i1  */
        { "\xb6\x04\x80\x12",4,1,1,1,1,0,0,1 },      /* add %l2,%l2,%i3   */
        { "\xa4\x04\xe0\x42",4,1,1,1,1,1,3,1 },      /* add %l3,0x42,%l2  */
        { "\x96\x23\x60\x42",4,1,1,1,1,1,3,1 },      /* sub %o5,0x42,%o3  */
        { "\x96\x24\x80\x12",4,1,1,1,1,0,0,1 },      /* sub %l2,%l2,%o3   */
        { "\xb2\x26\x80\x19",4,1,1,1,1,0,0,1 },      /* sub %i2,%i1,%i1   */
        { "\x89\xa5\x08\x22",4,1,1,1,1,0,0,1 },      /* fadds %f20,%f2,%f4*/
        { "\xa2\x1a\x40\x0a",4,1,1,1,1,0,0,1 },      /* xor %o1,%o2,%l1   */
        { "\x81\xd0\x20\x42",4,1,0,1,1,1,3,1 },      /* tn random         */
        { "\xa4\x32\xa0\x42",4,1,1,1,1,1,3,1 },      /* orn %o2,0x42,%l2  */
        { "\xa2\x03\x40\x12",4,1,1,1,1,0,0,1 },      /* add %o5,%l2,%l1   */
        { "\xba\x56\xa0\x42",4,1,1,1,1,1,3,1 },      /* umul %i2,0x42,%i5 */
        { "\xa4\x27\x40\x12",4,1,1,1,1,0,0,1 },      /* sub %i5,%l2,%l2   */
        { "\xa2\x0e\x80\x13",4,1,1,1,1,0,0,1 },      /* and %i2,%l3,%l1   */
        { "\xb6\x03\x60\x42",4,1,1,1,1,1,3,1 },      /* add %o5,0x42,%i3  */
        { "\x98\x3e\x80\x12",4,1,1,1,1,0,0,1 },      /* xnor %i2,%l2,%o4  */
        { "\x20\xbf\xbf\x42",4,1,0,1,1,1,3,1 }       /* bn -random        */
};

struct junks hppa_njunk[HPPA_JUNKS] = {
        { "\x08\x41\x02\x83",4,1,1,1,0,0,0,1 },      /* xor %r1,%r2,%r3         */
        { "\x08\x21\x02\x9a",4,1,1,1,1,0,0,1 },      /* xor %r1,%r1,%r26        */
        { "\x09\x6a\x02\x8c",4,1,1,1,1,0,0,1 },      /* xor %r10,%r11,%12       */
        { "\xb5\x03\xe0\x84",4,1,1,1,1,1,3,1 },      /* addi,OD 0x42,%r8,%r3    */
        { "\x09\xcd\x06\x0f",4,1,1,1,1,0,0,1 },      /* add %r13,%r14,%r15      */
        { "\x94\x6c\xe0\x84",4,1,1,1,1,1,3,1 },      /* subi,OD 0x42,%r3,%r12   */
        { "\x09\x09\x04\x07",4,1,1,1,1,0,0,1 },      /* sub %r9,%r8,%r7         */
        { "\xd0\xe8\x0a\xe9",4,1,1,1,1,0,0,1 },      /* shrpw %r8,%r7,8,%r9     */
        { "\x09\x04\x06\x8f",4,1,1,1,1,0,0,1 },      /* shladd %r4,2,%r8,%r15   */
        { "\x08\xa4\x02\x46",4,1,1,1,1,0,0,1 },      /* or  %r4,%r5,%r6         */
        { "\xb5\x4b\xe0\x84",4,1,1,1,0,1,3,1 }       /* addi,OD 0x42,%r10,%r11  */
};


#endif 
