/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: itemnode.h,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:44  slash
 * Initial release.
 *
 */

#ifndef ITEMNODE_H
#define ITEMNODE_H

#include "inlinenode.h"

//---------------------------------------------------------------------------
/**
 * This class represents an item-node.
 */
class ItemNode : public InlineNode {
  public:
    //-----------------------------------------------------------------------
    /**
     * This enumeration defines the possible values,
     * how the item should be printed.
     */
    enum Item_Style {
        NORMAL, WEAK
    };

    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the item-node.
     *
     * @param node The XML-node, which represents the item-node.
     * @param closing_p Indicates, if the HTML-output should have a
     *                  closing </P> tag.
     */
    ItemNode(xmlNodePtr node,
             int closing_p = 1);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~ItemNode();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     *
     * @param style How the item should be written (NORMAL or WEAK).
     */
    void writeHTML(int style = NORMAL) const;


  private:

    //-----------------------------------------------------------------------
    /**
     * Indicates, if the HTML-output should have a closing </P> tag or not.
     */
    int closing_p_;
};

#endif //ITEMNODE_H
