//
//  PRScale.m
//  PRICE
//
//  Created by Riccardo Mottola on Wed Jan 19 2005.
//  Copyright (c) 2005 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import <math.h>
#import "PRScale.h"


@implementation PRScale

- (NSImage *)scaleImage :(NSImage *)srcImage :(int)sizeX :(int)sizeY :(PRCProgress *)prPanel
{
    NSBitmapImageRep *srcImageRep;
    NSImage *destImage;
    NSBitmapImageRep *destImageRep;
    int origW, origH;
    int x, y;
    int i;
    unsigned char *srcData;
    unsigned char *destData;
    int bytesPerPixel;
    BOOL isColor;
    float xRatio, yRatio;
    
    /* some trace */
    NSLog(@"inside %@.%@", [self className], NSStringFromSelector(_cmd));
    
    progressSteps = 0;
    totalProgressSteps = 2;
    progPanel = prPanel;

    /* get source image representation and associated information */
    if (progPanel)
    {
        [self setActivity:@"Get image size"];
        [self advanceProgress];
    }
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    origW = [srcImageRep pixelsWide];
    origH = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;

    
    xRatio = (float)origW / (float)sizeX;
    yRatio = (float)origH / (float)sizeY;
    
    /* check bith depth and color/greyscale image */
    if ([srcImageRep hasAlpha])
    {
        if ([srcImageRep samplesPerPixel] == 2)
            isColor = NO;
        else
            isColor = YES;
    }
    else
    {
        if ([srcImageRep samplesPerPixel] == 1)
            isColor = NO;
        else
            isColor = YES;
    }
    
    /* allocate destination image and its representation */
    destImage = [[NSImage alloc] initWithSize:NSMakeSize(sizeX, sizeY)];
    if (isColor)
    {
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:sizeX
                    pixelsHigh:sizeY
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    } else
    {
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:sizeX
                    pixelsHigh:sizeY
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    }
    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (progPanel)
    {
        [self setActivity:@"Scale"];
        [self advanceProgress];
    }

    for (y = 0; y < sizeY; y++)
        for (x = 0; x < sizeX; x++)
            for (i = 0; i < bytesPerPixel; i++)
                destData[bytesPerPixel * (y * sizeX + x) + i] = srcData[bytesPerPixel * ((int)floor(y * yRatio) * origW + (int)floor(x * xRatio)) + i];
    
    if (progPanel)
    {
        [self setActivity:@"Done"];
        [self showProgress];
    }

    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}

@end
