%define name        printfilters
%define version     2.12
%define rel         2
%define prefix      /usr

# see the configure.in for a note on version numbers

Name: %{name}
Version: %{version}
Release: %{rel}
Summary: Print filters, for use with the gnulpr and printtool.
Copyright: GPL
Group: Applications/Publishing
Source0: %{name}-%{version}.tar.gz
Requires: mpage >= 2.4, lpr >= 0.70, ghostscript >= 5.10, file, libprintsys, ppdfilt
Buildroot: /var/tmp/printfilters-root
#
# these conflcts exists because Dr Mike changes the location of the filters
# and because Ben changed the name of the package.
#
Conflicts: libgr-progs < 2.0.9-7, rhs-printfilters, vine-printfilters

%description
The rhs-printfilters package contains a set of print filters which are
primarily meant to be used with the Red Hat printtool.  These print
filters provide an easy way for users to handle printing numerous file
formats.

%prep
%setup

%build
./configure --prefix=%{_prefix}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_prefix}
make DESTDIR="$RPM_BUILD_ROOT" install
# strip $RPM_BUILD_ROOT/usr/lib/rhs/rhs-printfilters/rewindstdin

find "$RPM_BUILD_ROOT" -type f -print \
  | sed -e "s@^${RPM_BUILD_ROOT}@@" > rpm.filelist

%clean 
rm -rf $RPM_BUILD_ROOT

%files -f rpm.filelist
%defattr(-,root,root)

%changelog
* Mon Jun 4 2001 Ben Woodard <ben@valinux.com>
- Added a dependency on ppdfilt.

* Fri Jun 1 2001 Ben Woodard <ben@valinux.com>
- Added a conflict with vine-printfilters so that red-carpet would work 
  properly with turbo.

* Wed May 23 2001 Ben Woodard <ben@valinux.com>
- tweaked with the dependencies now that it depends on libprintsys

* Tue Dec 19 2000 Ben Woodard <ben@valinux.com>
- merged in changes from rh 1.81 version

* Fri Apr 21 2000 Ben Woodard <ben@valinux.com>
- forked from the rh 1.63 version

* Mon Feb 28 2000 Bill Nottingham <notting@redhat.com>
- add a couple more lexmarks now in gs5.50

* Thu Feb 17 2000 Bill Nottingham <notting@redhat.com>
- fix wrong driver for laserjet plus

* Mon Feb 14 2000 Bill Nottingham <notting@redhat.com>
- ooops, put ppaprint in the filelist
- add some gs-5.50 mappings

* Fri Feb 11 2000 Bill Nottingham <notting@redhat.com>
- pnm2ppa support
- fix problem with rewindstdin

* Wed Jan 26 2000 Bill Nottingham <notting@redhat.com>
- add stylus color 740 to printerdb

* Mon Nov  8 1999 Bill Nottingham <notting@redhat.com>
- revert ps-to-printer tempfile usage. There has
  to be a better way to do this.

* Wed Jul 21 1999 Bill Nottingham <notting@redhat.com>
- munge smbprint Yet Again(tm)

* Thu Jul  8 1999 Bill Nottingham <notting@redhat.com>
- make printerdb config(noreplace)

* Thu Jul  1 1999 Bill Nottingham <notting@redhat.com>
- add more drivers

* Fri Jun 18 1999 Bill Nottingham <notting@redhat.com>
- fix rpm printing

* Mon Jun 14 1999 Bill Nottingham <notting@redhat.com>
- use smbclient's -c command. Makes much more sense.

* Mon May 24 1999 Bill Nottingham <notting@redhat.com>
- hmm. The translate option went away at some point. Oops.

* Mon May  3 1999 Bill Nottingham <notting@redhat.com>
- yet another typo in SMB stuff. Urg.

* Mon Apr  5 1999 Bill Nottingham <notting@redhat.com>
- strip binaries

* Thu Apr  1 1999 Bill Nottingham <notting@redhat.com>
- fix some printerdb stuff for ghostscript brokenness

* Fri Mar 19 1999 Bill Nottingham <notting@redhat.com>
- remove some oboslete text

* Mon Feb  8 1999 Bill Nottingham <notting@redhat.com>
- uniprint support

* Tue Dec 29 1998 Bill Nottingham <notting@redhat.com>
- add workaround for Adobe(!) postscript driver

* Mon Dec 28 1998 Bill Nottingham <notting@redhat.com>
- remove 1bpp from cdj-based drivers, 'cos it's broken.

* Wed Nov 18 1998 Bill Nottingham <notting@redhat.com>
- add workgroup support to smbprint, fix quoting issues

* Wed Sep 30 1998 Bill Nottingham <notting@redhat.com>
- fix typo in ncpprint

* Wed Sep 15 1998 Bill Nottingham <notting@redhat.com>
- Added ncpprint to %files section (oops!)

* Thu Sep  2 1998 Bill Nottingham <notting@redhat.com>
- Added NCP printing support

* Tue Jun 30 1998 Michael Maher <mike@redhat.com>
- Fixed BUG 703,  added findutils dependecy.
- Added buildroot.

* Fri May 08 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Wed Oct 22 1997 Michael Fulbright <msf@redhat.com>
- Fixed printerdb to include 300x300 resolution for LaserJet 4 models
- Restored troff file handling now troff fpi is 'safe'

* Tue Oct 14 1997 Michael Fulbright <msf@redhat.com>
- Fixed master-filter to NOT handle troff files automatically

* Thu Jul 31 1997 Erik Troan <ewt@redhat.com>
- built against glibc

* Wed Apr 23 1997 Michael Fulbright <msf@redhat.com>
- Fixed problem with asc-to-printer.fpi not handling cr/lf trans correct

* Fri Apr 18 1997 Michael Fulbright <msf@redhat.com>
- fixed up Canon 600/4000 printerdb def
- added some HP Deskjets which I know work

* Thu Apr 10 1997 Michael Fulbright <msf@redhat.com>
- Added requirement that gs is installed. Pretty useless w/o it if
  you print anything interesting.

* Fri Mar 13 1997 Michael Fulbright <msf@redhat.com>
- Added conflicts so that packages with old filter loc won't hurt us.
- Moved to version 1.2.
- Added mpage support to allow nup printing.

* Wed Mar 13 1997 Michael Fulbright <msf@redhat.com>
- Added a DeskJet500Mono driver which links to the gs driver djet500.
- Added a A4 paper size test page.
- Fixed Makefile to build .ps test pages from the .fig files.

* Mon Mar 10 1997 Michael Fulbright <msf@redhat.com>
- Split filters off from printtool into this package .
