/***************************************************************************
                          gui_taglisting.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_TAGLISTING_H
#define GUI_TAGLISTING_H

#include "prokyon.h"

#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qwidgetstack.h>
#include <qptrlist.h>
#include <qspinbox.h>
#include <qradiobutton.h>

#include <qlistview.h>

#include "extendedpushbutton.h"

class GUI_TagListing : public QFrame  {
  Q_OBJECT
 public: 
  GUI_TagListing(QWidget *parent, QListView *_tracklist, const char *name=0);
  
  void setConnectionState(bool state);

  void notifyAddEditLock();
  void notifyRemoveEditLock();
  void notifyEnableEdit(bool);
 
  void notifySelectionChanged();
  void notifyCurrentChanged(QListViewItem *lvi);
  void notifySortingInEditModeChanged();
  
  ~GUI_TagListing();
  
 private:
  QListView *tracklist;

  QList<QListViewItem> selectedItems;

  int currentTrack;

  int editLock;

  bool editMode, editEnabled, doNothing;  

  void setAlbumInformationFromComment(QString comment);
  
  QPushButton *buttonEdit, *buttonApply, *buttonDiscard;

  ExtendedPushButton *buttonFilename, *buttonTitle, *buttonArtist, *buttonAlbum, *buttonYear, *buttonGenre, *buttonComment, *buttonTrack, *buttonAlbumInfo;
  ExtendedPushButton *buttonLastClicked;
  
  QWidgetStack *stackFilename, *stackTitle, *stackArtist, *stackAlbum, *stackYear, *stackGenre, *stackComment, *stackTrack;
  QLabel *labelFilename, *labelTitle, *labelArtist, *labelAlbum, *labelYear, *labelGenre, *labelComment, *labelInfo, *labelTrack, *labelSum;
  QLineEdit *editFilename, *editTitle, *editArtist, *editAlbum, *editYear, *editComment;
  QSpinBox *spinTrack;
  QLabel *labelFile;
  QComboBox *comboGenre;
  QRadioButton *standardAlbum;
  QRadioButton *samplerAlbum;
  QRadioButton *soundtrackAlbum;

  QString oldtip;
  
    bool statusleft, statusright, autohide;

    void getSelectedItems();
  void applyCurrentTrack();
  void switchMode(int, bool);
  QString filter_ext2(QString filename);


 private slots:
  
  void slot_editbutton();
  void slot_applybutton();
  void slot_discardbutton();
  
  void slot_filenameEdit(const QString&);
  void slot_artistEdit(const QString&);
  void slot_titleEdit(const QString&);
  void slot_albumEdit(const QString&);
  void slot_tracknumberChanged(int);
  void slot_yearEdit(const QString&);
  void slot_commentEdit(const QString&);
  void slot_genreCombo(int);
  void slot_albumbox(int);  

  void slot_artistButton();
  void slot_titleButton();
  void slot_albumButton();
  void slot_yearButton();
  void slot_trackButton();
  void slot_autotrackButton();
  void slot_commentButton();
  void slot_genreButton();
  void slot_albumInfoButton();
  
  void slot_buttonContext(ExtendedPushButton*, const QPoint&);

  void slot_menuDiscardChanges();
  void slot_menuDiscardChangesALL();
  void slot_menuStandardFilename();
  void slot_menuStandardFilenameALL();
  void slot_menuAndromedaFilename();
  void slot_menuAndromedaFilenameALL();
  void slot_menuFLUpcase();
  void slot_menuFLUpcaseALL();
  void slot_menuDowncase();
  void slot_menuDowncaseALL();
  void slot_menuHelpAndromeda();

  void slot_selPrevTrack();
  void slot_selNextTrack();
};

#endif
