/***************************************************************************
        	    job_connecttodatabase.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_connecttodatabase.h"

#include "job_disconnectfromdatabase.h"
#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"

Job_ConnectToDatabase::Job_ConnectToDatabase(QString _host, QString _db, QString _user, QString _pass)
  : host(_host), db(_db), user(_user), pass(_pass)
{}

void Job_ConnectToDatabase::run()
{
  int error = 0;

  database->lock();
  
  database->establishConnection(host, db, user, pass);
  
  app->lock();

  error = database->getError();

  if(!error) {
    datadispatcher->eventEstablishedConnection();
    datadispatcher->eventNewArtistAlbumBasis(database->getArtistAlbumBasis());
    datadispatcher->eventNewFavouritesBasis(database->getFavouritesBasis());
    datadispatcher->eventNewSamplerBasis(database->getSamplerBasis());
    datadispatcher->eventNewLocalDeltaBasis(database->getLocalDeltaBasis());
    datadispatcher->eventNewLocalAlbumDeltaBasis(database->getLocalAlbumDeltaBasis());
    datadispatcher->eventNewMediumBasis(database->getMediumBasis());
    datadispatcher->eventNewPlaylistBasis(database->getPlaylistBasis());
    datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(0),0);

    error = database->getError();
  }
  
  app->unlock();
  database->unlock();
  
//  if(error) {
//    jobman->lock();
//    jobman->addJob(new Job_DisconnectFromDatabase());
//    jobman->unlock();
//  }
  
  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
  exit();
}

Job_ConnectToDatabase::~Job_ConnectToDatabase() {}
