# $Id: Filter.pm,v 1.4 2001/04/12 06:14:08 muhri Exp $
# -*- perl -*-
package Pronto::Filter;
use strict;
use SelfLoader;
1;
__DATA__
sub filter_editwin {
  	my ($widget, $filter_clist, $action, $row,$flytype) = @_;
	my ($fw_dlg, $type, $boxid, $regex, $addr, $name, $fltid, $lbl1, $c_score, $hbox7, $lbl7,
	$lbl2, $lbl3, $lbl4, $lbl5, $lbl6, $hbox1, $hbox2, $hbox3, $hbox4, $hbox5,
	$hbox6, $hbox8, $e_name, $c_type, $c_boxid, $c_acct, $e_regex, $e_addr, $fw_ok,
	$fw_cancel, %acctlist, @row, @acctnms, @selection, $trueregex,
	$cb_regex, $count, $cb_count,$sql,$query);
  
  	if ($action eq "edit") {
   		if (not defined $row) {
    			if (@selection = $filter_clist->selection()) {
     			$row = $selection[0];
    			} else {
			&main::err_dialog(_("Select a filter to edit first!"));
			return 1; 
    			}
   		}
   	$fltid = ${$filter_clist->get_row_data($row)};
  	}
  
  	if ($fltid) {
   		$sql = "select type, boxid, regex, addr, name, trueregex, count from filters where id=?";
   		$query = $main::conn->prepare($sql);
   		$query->execute($fltid);
   		($type, $boxid, $regex, $addr, $name, $trueregex, $count) = $query->fetchrow_array();
  	} elsif ($action eq "newfromlist") {
  		my (@msg_sel,$id,$sql2,$query2);
		$id = &Pronto::MessageList::get_selected_msgid();
  		if (!$id) { &main::err_dialog(_("Select a Message first!")); return 1 }
        if ($flytype eq "to") {
   			$sql2 = "select sentto from messages where id = '$id'";
   			$query2 = $main::conn->prepare($sql2);
   			$query2->execute;
   			$regex = $query2->fetchrow_array;
   			$name = $regex;
   			$name =~s/\<(.+)//g;
   			$name =~s/\"//g;
   			$name =~s/\'//g;
   			$name =~s/\@(.+)//g;
   			($type,$boxid,$addr,$trueregex,$count) = (2,1,"",0,-1);
  		} elsif ($flytype eq "subject") {
  			$sql2 = "select subject from messages where id = '$id'";
   			$query2 = $main::conn->prepare($sql2);
   			$query2->execute;
   			$regex = $query2->fetchrow_array;
   			$regex =~s/RE\: //i;
   			$name = $regex;
   			($type,$boxid,$addr,$trueregex,$count) = (3,1,"",0,-1);
  		} elsif ($flytype eq "from") {
  			$sql2 = "select sentfrom from messages where id = '$id'";
			$query2= $main::conn->prepare($sql2);
  			$query2->execute;
  			$regex = $query2->fetchrow_array;
  			$name = $regex;
   			$name =~s/\<(.+)//g;
   			$name =~s/\"//g;
   			$name =~s/\'//g;
   			$name =~s/\@(.+)//g;
  			($type,$boxid,$addr,$trueregex,$count) = (4,1,"",0,-1);
  		}
  
  	} else {
   		($type, $boxid, $regex, $addr, $name, $trueregex,$count) = (0,1,"","","",0,-1);
    	}
	
  	$sql = "select descr, id from accounts";
  	$query = $main::conn->prepare($sql);
  	$query->execute();
  	while (@row=$query->fetchrow_array()) {
   		$acctlist{$row[1]}=$row[0];
   		push @acctnms, $row[0];
  	}
  	$fw_dlg = new Gtk::Dialog;
  	$fw_dlg->signal_connect("destroy" => sub { $fw_dlg->destroy; });
  	$fw_dlg->signal_connect("delete_event" => \&Gtk::false);
  	$fw_dlg->set_title("Filter Editor");
  	$fw_dlg->position(-mouse);
  	$fw_dlg->border_width(5);
  	$lbl1 = new Gtk::Label (_("Filter Name:"));
  	$lbl1->set_alignment(0.5,0.5);
  	$lbl1->set_usize(100,10);
  	$lbl1->show;
  	$e_name = new Gtk::Entry;
  	$e_name->set_text($name);
  	$e_name->set_editable('1');
  	$e_name->show;
  	$hbox1=new Gtk::HBox(0,0);
  	$hbox1->border_width('3');
  	$hbox1->pack_start($lbl1,0,1,0);
  	$hbox1->pack_start($e_name,1,1,0);
  	$lbl2 = new Gtk::Label (_("Filter Type:"));
  	$lbl2->set_alignment(0.5,0.5);
  	$lbl2->set_usize(100,10);
  	$lbl2->show;
  	$c_type = new Gtk::Combo;
  	$c_type->set_case_sensitive('0');
  	$c_type->set_use_arrows('1');
  	$c_type->set_popdown_strings(@main::flttypes);
  	$c_type->entry->set_text($main::flttypes[$type]);
  	$c_type->show;
  	$hbox2=new Gtk::HBox(0,0);
  	$hbox2->border_width('3');
  	$hbox2->pack_start($lbl2,0,1,0);
  	$hbox2->pack_start($c_type,1,1,0);
  	$lbl3 = new Gtk::Label (_("Folder to Move to:"));
  	$lbl3->set_alignment(0.5,0.5);
  	$lbl3->set_usize(100,10);
  	$lbl3->show;
  	$c_boxid = new Gtk::Combo;
  	$c_boxid->set_case_sensitive('0');
  	$c_boxid->set_use_arrows('1');
  	$c_boxid->set_popdown_strings(sort(keys(%main::foldernametoid)));
  	$c_boxid->entry->set_text($main::folderidtoname{$boxid});
  	$c_boxid->show;
  	$hbox3=new Gtk::HBox(0,0);
  	$hbox3->border_width('3');
  	$hbox3->pack_start($lbl3,0,1,0);
  	$hbox3->pack_start($c_boxid,1,1,0);
	$cb_regex=new_with_label Gtk::CheckButton(_("True perl regex (read man perlre!)"));
	$cb_regex->show();
	$cb_regex->set_active(1) if (defined $trueregex && $trueregex == 1);
  	$lbl6 = new Gtk::Label (_("if received on Account:"));
  	$lbl6->set_usize(120,10);
  	$lbl6->set_alignment(0.5,0.5);
  	$lbl6->show;
  	$c_acct = new Gtk::Combo;
  	$c_acct->set_case_sensitive('0');
  	$c_acct->set_use_arrows('1');
  	$c_acct->set_popdown_strings(@acctnms);
  	if ($regex =~ /^\d/) {
   		$c_acct->entry->set_text($acctlist{$regex});
  	}
  	$c_acct->show;
  	$hbox6=new Gtk::HBox(0,0);
  	$hbox6->border_width('3');
  	$hbox6->pack_start($lbl6,0,1,0);
  	$hbox6->pack_start($c_acct,1,1,0);
  	$lbl4 = new Gtk::Label (_("Search Expression:"));
  	$lbl4->set_usize(100,10);
  	$lbl4->set_alignment(0.5,0.5);
  	$lbl4->show;
  	$e_regex = new Gtk::Entry;
  	$e_regex->set_text($regex);
  	$e_regex->set_editable('1');
  	$e_regex->show;
  	$hbox4=new Gtk::HBox(0,0);
  	$hbox4->border_width('3');
  	$hbox4->pack_start($lbl4,0,1,0);
  	$hbox4->pack_start($e_regex,1,1,0);
  	$lbl5 = new Gtk::Label ("Forward To:");
  	$lbl5->set_alignment(0.5,0.5);
  	$lbl5->set_usize(100,10);
  	$lbl5->show;
  	$e_addr = new Gtk::Entry;
  	$e_addr->set_text($name);
  	$e_addr->set_editable('1');
  	$e_addr->show;
  	$hbox5=new Gtk::HBox(0,0);
  	$hbox5->border_width('3');
  	$hbox5->pack_start($lbl5,0,1,0);
  	$hbox5->pack_start($e_addr,1,1,0);
  	$hbox7 = new Gtk::HBox(0,0);
  	$hbox7->border_width('3');
  	$c_score = new Gtk::Combo;
  	$c_score->set_case_sensitive('1');
  	$c_score->set_use_arrows('1');
  	$c_score->set_popdown_strings("-3", "-2", "-1", "1", "2", "3");
  	$c_score->entry->set_text($boxid);
  	$c_score->show;
  	$lbl7 = new Gtk::Label(_("Score Modifier:"));
  	$lbl7->set_usize(100,10);
  	$lbl7->set_alignment(0.5,0.5);
  	$lbl7->show;
  	$hbox7->pack_start($lbl7,0,1,0);
  	$hbox7->pack_start($c_score,1,1,0);
  	$hbox8 = new Gtk::HBox(0,0);
  	$hbox8->border_width('3');
  	$cb_count=new_with_label Gtk::CheckButton(_("Count Filter Hits"));
  	$cb_count->show();
  	$cb_count->set_active(1) if (defined $count && $count >= 0);
  	my $apply_filter = new Gtk::CheckButton(_("Apply Now"));
	$apply_filter->set_active(0);
	$apply_filter->show() if (defined $flytype);
	$hbox8->pack_start($cb_count,0,1,0);
  	$hbox8->pack_start($cb_regex,1,1,0);
  	$hbox8->pack_start($apply_filter,1,1,0);
	$hbox8->show;
  	$hbox1->show;
       	$hbox2->show;
  	$hbox3->show;
  	if ($type != 1) {$hbox4->show;} else {$hbox6->show;}
  	if ($type == 6) {$hbox3->hide; $hbox7->show;}
  	$fw_dlg->vbox->pack_start($hbox1,1,1,0);
  	$fw_dlg->vbox->pack_start($hbox2,1,1,0);
  	$fw_dlg->vbox->pack_start($hbox3,1,1,0);
  	$fw_dlg->vbox->pack_start($hbox7,1,1,0);
  	$fw_dlg->vbox->pack_start($hbox4,1,1,0);
  	$fw_dlg->vbox->pack_start($hbox6,1,1,0);
  	$fw_dlg->vbox->pack_start($hbox5,1,1,0);
  	$fw_dlg->vbox->pack_start($hbox8,1,1,0);

  	$fw_ok=new Gtk::Button _("Ok");
 	$fw_ok->signal_connect("clicked" => \&Pronto::TableEdit::update_filters, $action,
    		$fw_dlg, $filter_clist, $e_name, $c_type, $c_boxid, $e_regex,
    		$e_addr, $c_acct, $fltid, $c_score, $cb_regex, $cb_count, $count, $apply_filter);
  	$fw_ok->can_default(1);
 	$fw_ok->show;
  	$fw_dlg->action_area->pack_start($fw_ok,1,1,0);
  	$fw_cancel=new Gtk::Button _("Cancel");
  	$fw_cancel->signal_connect("clicked", sub { $fw_dlg->destroy; });
  	$fw_dlg->action_area->pack_start($fw_cancel,1,1,0);
  	$fw_ok->grab_default;
  	$fw_cancel->show;
  	$fw_dlg->show;
  	$c_type->popwin->signal_connect("hide", \&ftype_change,
    		$c_type, $hbox4, $hbox6, $hbox7, $hbox3);
  	$c_boxid->popwin->signal_connect("hide", \&fboxid_change,
    		$c_boxid, $hbox5);
return 1;
}

sub ftype_change {
 	my ($widget, $c_type, $hbox4, $hbox6, $hbox7, $hbox3) = @_;
 	if ($c_type->entry->get_text() eq _("Account Based")) {
  		$hbox4->hide;
  		$hbox6->show;
  		$hbox7->hide;
  		$hbox3->show;
 	} elsif ($c_type->entry->get_text() eq _("Scoring")) {
       		$hbox4->show;
  		$hbox6->hide;
  		$hbox3->hide;
  		$hbox7->show;
 	} else {
  		$hbox4->show;
  		$hbox6->hide;
  		$hbox7->hide;
  		$hbox3->show;
 	}
 
return 1;
}

sub fboxid_change {
 	my ($widget, $c_boxid, $hbox5) = @_;
 	if ($c_boxid->entry->get_text() eq "Outbox") {
  		$hbox5->show;
 	} else {
  		$hbox5->hide;
 	}
 
 return 1;
}

sub filter_reorder {
	my ($clist,$oldpos,$newpos) = @_;
	my $i=0;
	my ($id,$oldid,$sql,$query);
	if ($oldpos>$newpos){
		#okay, we have a bacward drag
		#get the element
		$oldid=${$clist->get_row_data($oldpos)};
		for ($i=$oldpos;$i>=$newpos;$i--){
			$id=${$clist->get_row_data($i)};
			$sql="update filters set sorder=".($i+1)." where id=$id";
			$query=$main::conn->prepare($sql);
			$query->execute();
		}
		# now move the elemnt to the new pos
		$sql="update filters set sorder=$newpos where id=$oldid";
		$query=$main::conn->prepare($sql);
		$query->execute();
	} else {
		# and here we have a forward order
		$oldid=${$clist->get_row_data($oldpos)};
		for ($i=$oldpos;$i<=$newpos;$i++){
			$id=${$clist->get_row_data($i)};
			$sql="update filters set sorder=".($i-1)." where id=$id";
			$query=$main::conn->prepare($sql);
			$query->execute();
		}
		# now move the elemnt to the new pos
		$sql="update filters set sorder=$newpos where id=$oldid";
		$query=$main::conn->prepare($sql);
		$query->execute();
	}

	return 1;
}

