/* 
 * Prospect: a developer's system profiler.
 * System Tests: symbol discrimination.
 *
 * COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
 *
 * Author: Bob Montgomery, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: syms.c,v 1.3 2004/01/09 20:29:28 type2 Exp $ */

/*  syms - a test program for gprof/prospect with lots of small functions
 *  and a controlled execution pattern.
 */

#define SCALE 10000

#include <stdio.h>
#include <stdlib.h>

void usage(char *prog)
{
    printf("usage: %s pattern iterations\n", prog);
    printf("       patterns: even, odd, all\n");
}

extern long do_evens(long,long);
extern long do_odds(long, long);
extern long do_all(long, long);

int
main(int argc, char **argv)
{
    long iter;

    if (argc != 3) {
        usage(argv[0]);
        exit(1);
    }

    iter = strtol(argv[2], NULL, 0);

    switch(argv[1][0]) {
        case 'e':
            printf("evens: %ld\n", do_evens(SCALE, iter));
            break;
        case 'o':
            printf("odds:  %ld\n", do_odds(SCALE, iter));
            break;
        case 'a':
            printf("all:   %ld\n", do_all(SCALE, iter));
            break;
        default:
            usage(argv[0]);
            exit(1);
    }
    return 0;
}
