/****************************************************************************
** accountdlg.h - dialogs for manipulating Jabber accounts
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef ACCOUNTDLG_H
#define ACCOUNTDLG_H

#include<qdialog.h>
#include<qlistview.h>
#include"profiles.h"
#include"uniquewindow.h"
#include"jabsess.h"
#include"ui_accountmanage.h"
#include"ui_accountmodify.h"
#include"busywidget.h"


class AccountViewItem : public QListViewItem
{
public:
	AccountViewItem(QListView *, JabSession *);

	JabSession *s;

	void updateInfo();
};

class AccountManageDlg : public AccountManageUI
{
	Q_OBJECT
public:
	AccountManageDlg(JabSessionManager *, QWidget *parent=0, const char *name=0);
	~AccountManageDlg();

	static AccountManageDlg *find();

signals:
	void signalModify(const QString &);

public slots:
	void updateEntry(JabSession *);
	void sessionUpdate(JabSession *);

private slots:
	void modify();
	void modify(QListViewItem *);

private:
	JabSessionManager *jsm;
};

class AccountModifyDlg : public AccountModifyUI, public UniqueWindow
{
	Q_OBJECT
public:
	AccountModifyDlg(JabSession *, bool haveSSL, QWidget *parent=0, const char *name=0);
	~AccountModifyDlg();

	static AccountModifyDlg *find(const QString &accname);

private slots:
	void sslToggled(bool);
	void save();
	void doRegister();

private:
	JabSession *s;
	bool haveSSL;
};

class AccountRegisterDlg : public QDialog
{
	Q_OBJECT
public:
	AccountRegisterDlg(QWidget *parent=0, const char *name=0);
	~AccountRegisterDlg();

	void start(const QString &, int, bool, const QString &, const QString &);
	void stop();

	static bool reg(QWidget *, const QString &, int, bool, const QString &, const QString &);

protected:
	// reimplemented
	void closeEvent(QCloseEvent *);

private slots:
	void accRegisterFinished(bool, const QString &);
	void jab_error(JabError *);
	void cancel();

private:
	Jabber *jab;
	BusyWidget *busy;
};

#endif
