/****************************************************************************
** anim.cpp - handles animations
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"anim.h"
#include<qimage.h>

Anim::Anim(const QPixmap &pix)
{
	QImage image = pix.convertToImage();

	seq.setAutoDelete(TRUE);
	qim_seq.setAutoDelete(TRUE);

	int n;
	for(n = 0; ((n+1) * 16) <= image.width(); ++n) {
		seq.resize(n+1);
		qim_seq.resize(n+1);

		qim_seq.insert(n, new QImage(image.copy(n * 16, 0, 16, 16)) );
		seq.insert(n, new QPixmap);
		seq[n]->convertFromImage(*qim_seq[n]);
	}

	// hopefully this never happens
	if(n == 0) {
		seq.resize(1);
		qim_seq.resize(1);

		seq.insert(0, new QPixmap(16,16));
		seq[0]->fill(Qt::black);
		qim_seq.insert(0, new QImage(seq[0]->convertToImage()) );
		v_isAnim = FALSE;
		v_numFrames = 0;
		return;
	}

	v_isAnim = FALSE;
	v_numFrames = n - 1;
	if(v_numFrames > 0)
		v_isAnim = TRUE;
}

Anim::~Anim()
{
}

QPixmap & Anim::frame(int x)
{
	// if we don't have the frame, just return the base
	if(!seq[x+1])
		return *seq[0];

	return *seq[x+1];
}

QPixmap & Anim::base()
{
	return *seq[0];
}

QImage & Anim::qim_frame(int x)
{
	if(!qim_seq[x+1])
		return *qim_seq[0];

	return *qim_seq[x+1];
}

QImage & Anim::qim_base()
{
	return *qim_seq[0];
}

