/****************************************************************************
** jabsess.h - keeps track of Jabber accounts/sessions
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef JABSESS_H
#define JABSESS_H

#include<qobject.h>
#include<qptrlist.h>
#include"profiles.h"
#include"jabber.h"
#include"userlist.h"
#include"statusdlg.h"
#include"contactview.h"


/****************************************************************************
  JabSession, JabSessionManager

  JabSession wraps a Jabber instance, as well as any other necessary
  variables.  With the help of JabSessionManager, a bunch of insane
  signal remapping is done so that each event from Jabber can be associated
  with the correct JabSession.

  JabSession now handles much of the functionality that the old jabcon used
  to.  Also, organization-wise, I consider JabSession to be on the same
  level in the class hierarchy as jabcon, so it need not always go through
  jabcon to get things done.  It can open its own windows, etc.

****************************************************************************/
class JabSessionManager;

class JabSession : public QObject
{
	Q_OBJECT

public:
	JabSession(JabSessionManager *par);
	~JabSession();

	bool isActive() { return v_isActive; }
	void setActive(bool b) { v_isActive = b; }

	void setAccount(const UserAccount &);
	void setContactProfile(ContactProfile *);

	Jabber *serv() { return &v_serv; }
	UserAccount *acc() { return &v_acc; }
	ContactProfile *cp() { return v_cp; }

	const QString &name() { return v_acc.name; }

	void conn();
	void disc(bool fast=FALSE);

	void setStatus(const StatusInfo &);

	UserList userlist;
	int localStatus;
	QString localStatusString;
	bool usingAutoStatus;
	bool isDisconnecting; // flag during user-initiated disconnect
	bool onEventOnlineOk;
	StatusInfo loginAs;

signals:
	void connected();
	void disconnected();

	void statusUpdate(JabUpdate *);
	void error(JabError *);

	void messageReceived(const JabMessage &);

	void resourceAvailable(const Jid &, const JabResource &);
	void resourceUnavailable(const Jid &);

	void contactChanged(JabRosterEntry *);
	void contactNew(JabRosterEntry *);
	void contactRemove(JabRosterEntry *);

	void authRequest(const Jid &from);
	void authGrant(const Jid &from);
	void authRemove(const Jid &from);

public slots:
	void secondsIdle(int);
	void update(bool);

private slots:
	void slotDisconnected();

private:
	bool v_isActive;
	Jabber v_serv;
	UserAccount v_acc;
	ContactProfile *v_cp;
};


//
//  JabSessionManager - remaps class Jabber signals
//

class JabSessionManager : public QObject
{
	Q_OBJECT

public:
	JabSessionManager(QObject *par=0);
	~JabSessionManager();

	void add(JabSession *);
	void clear();
	void manage();
	JabSession *find(const QString &);
	QPtrList<JabSession> getList() { return list; }
	void childUpdate(JabSession *);

signals:
	void sessionUpdate(JabSession *);
	void accountSettingsChanged();

	void jab_connected(JabSession *);
	void jab_disconnected(JabSession *);
	void jab_statusUpdate(JabSession *, JabUpdate *);
	void jab_error(JabSession *, JabError *);
	void jab_messageReceived(JabSession *, const JabMessage &);
	void jab_resourceAvailable(JabSession *, const Jid &, const JabResource &);
	void jab_resourceUnavailable(JabSession *, const Jid &);
	void jab_contactChanged(JabSession *, JabRosterEntry *);
	void jab_contactNew(JabSession *, JabRosterEntry *);
	void jab_contactRemove(JabSession *, JabRosterEntry *);
	void jab_authRequest(JabSession *, const Jid &);
	void jab_authGrant(JabSession *, const Jid &);
	void jab_authRemove(JabSession *, const Jid &);

public slots:
	void modify(const QString &);
	void modify(JabSession *);

private slots:
	void slotConnected();
	void slotDisconnected();
	void slotStatusUpdate(JabUpdate *);
	void slotError(JabError *);
	void slotMessageReceived(const JabMessage &);
	void slotResourceAvailable(const Jid &, const JabResource &);
	void slotResourceUnavailable(const Jid &);
	void slotContactChanged(JabRosterEntry *);
	void slotContactNew(JabRosterEntry *);
	void slotContactRemove(JabRosterEntry *);
	void slotAuthRequest(const Jid &);
	void slotAuthGrant(const Jid &);
	void slotAuthRemove(const Jid &);

private:
	QPtrList<JabSession> list;
};

#endif
