#!/usr/bin/env python

from distutils.core import setup

setup(name='Pygmy',
        version='0.48',
        description='GTK+ client for the Music Player Daemon (MPD).',
        author='Andrew Conkling',
        author_email='andrewski@fr.st',
        url='http://pygmy.berlios.de',
        classifiers=[
            'Development Status :: 4 - Beta',
            'Environment :: X11 Applications',
            'Intended Audience :: End Users/Desktop',
            'License :: GNU General Public License (GPL)',
            'Operating System :: Linux',
            'Programming Language :: Python',
            'Topic :: Multimedia :: Sound :: Players',
            ],
        py_modules = ['pygmy'],
        scripts = ['pygmy', 'bantu'],
        data_files=[('share/pygmy',
                        ['pygmy.glade', 'README']),
                    ('share/man/man1',
                        ['pygmy.1']),
                    ('share/applications',
                        ['pygmy.desktop']),
                    ('share/pixmaps',
                        ['pygmy.svg', 'pygmy.png', 'pygmyplaylist.svg', 'pygmyplaylist.png'])],
        )
