# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import os
import consts
import preferences
import typeToolBox
import xml.dom.ext
import xml.dom.minidom

# Default values are used at first
prefs = preferences.Preferences()

# Then saved preferences are loaded from the disk
if os.access(consts.filePrefs, os.F_OK) :
    for elt in xml.dom.minidom.parse(consts.filePrefs).documentElement.getElementsByTagName('pref') :
        name  = elt.getAttribute('name')
        value = typeToolBox.cast(elt.getAttribute('value'), elt.getAttribute('type'))
        prefs.__dict__[name] = value


def save() :
    global prefs
    doc  = xml.dom.minidom.Document()
    root = doc.createElement('prefs')
    doc.appendChild(root)

    for pref in prefs.__dict__.keys() :
        value = prefs.__dict__[pref]
        node = doc.createElement('pref')
        node.setAttribute('name', pref)
        node.setAttribute('value', str(value))
        node.setAttribute('type', typeToolBox.getType(value))
        root.appendChild(node)

    file_object = open(consts.filePrefs, "w")
    xml.dom.ext.PrettyPrint(doc, file_object)
    file_object.close()
