## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 2000 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus@oberhumer.com>
## http://www.oberhumer.com/pysol
##
##---------------------------------------------------------------------------##


# imports
import sys, os
import Tkinter

# PySol imports
from mfxtools import *
from mfxutil import EnvError
from util import PACKAGE, PACKAGE_URL, VERSION
from pysoltk import tkname, makeHelpToplevel, wm_map, wm_set_icon
from pysoltk import MfxDialog
from pysoltk import tkHTMLViewer


# /***********************************************************************
# //
# ************************************************************************/

class AboutDialog(MfxDialog):
    def createFrames(self, kw):
        top_frame, bottom_frame = MfxDialog.createFrames(self, kw)
        return top_frame, bottom_frame


def helpAbout(app, timeout=0, sound=1):
    if sound:
        app.audio.playSample("about")
    t = "A Python Solitaire Game Collection\n"
    if app.miscrandom.random() < 0.8:
        t = "A World Domination Project\n"
    if PACKAGE == "PyJongg":
        t = "A Python Mahjongg Game Collection\n"
    strings=("Nice", "Credits...")
    if timeout:
        strings=("Enjoy",)
    d = AboutDialog(app.top, title="About " + PACKAGE, timeout=timeout,
               text=PACKAGE+"\n" + t +
                    "Version " + VERSION + "\n\n" +
                    "Copyright (C) 1998, 1999, 2000, 2001 Markus F.X.J. Oberhumer\n" +
###                    "markus@oberhumer.com\n\n" +
                    "All Rights Reserved.\n\n" +
                    PACKAGE+" is free software distributed under the terms\n" +
                    "of the GNU General Public License\n\n" +
                    "For more information about this application visit\n" +
                    PACKAGE_URL,
               image=app.gimages.logos[2],
               strings=strings, default=0,
               separatorwidth=2)
    if d.status == 0 and d.button == 1:
        helpCredits(app, sound=sound)
    return d.status


def helpAboutSimple(app, timeout=0, sound=1):
    if sound:
        app.audio.playSample("about")
    t = "A Solitaire Game Collection\n"
    if PACKAGE == "PyJongg":
        t = "A Python Mahjongg Game Collection\n"
    d = MfxDialog(app.top, title="About " + PACKAGE, timeout=timeout,
               text=PACKAGE+"\n" + t +
                    "Version " + VERSION + "\n\n" +
                    "Copyright (C) 1998, 1999, 2000, 2001\nMarkus F.X.J. Oberhumer\n" +
                    "\nFor more information about this application visit\n" +
                    PACKAGE_URL,
               image=app.gimages.logos[2],
               strings=("Enjoy", ), default=0,
               separatorwidth=2)
    return d.status


def helpCredits(app, timeout=0, sound=1):
    if sound:
        app.audio.playSample("credits")
    t = ""
    if tkname == "tk": t = "Tcl/Tk, "
    elif tkname == "gnome": t = "PyGTK, "
    elif tkname == "kde": t = "pyKDE, "
    elif tkname == "wx": t = "wxPython, "
    d = MfxDialog(app.top, title=PACKAGE+" Credits", timeout=timeout,
               text=PACKAGE+" credits go to:\n\n" +
                    "Volker Weidner for getting me into Solitaire\n" +
                    "Guido van Rossum for the initial example program\n" +
                    "T. Kirk for lots of contributed games and cardsets\n" +
                    "Carl Larsson for the background music\n" +
                    "The Gnome AisleRiot team for parts of the documentation\n" +
                    "\n" +
                    "The Python, " + t + "SDL & Linux crews\nfor making this program possible",
               image=app.gimages.logos[3], image_side="right",
               separatorwidth=2)
    return d.status


# /***********************************************************************
# //
# ************************************************************************/

help_html_index = None

def helpHTML(app, document, dir):
    if not document:
        return None
    try:
        doc = app.dataloader.findFile(document, dir)
        global help_html_index
        if help_html_index is None:
            document, dir = "index.html", "html"
            help_html_index = app.dataloader.findFile(document, dir)
    except EnvError:
        d = MfxDialog(app.top, title=PACKAGE + " HTML Problem",
                      text="Cannot find help document\n" + document,
                      bitmap="warning")
        return None
    top = makeHelpToplevel(app.top, title=PACKAGE+" Help")
    if top.winfo_screenwidth() < 800 or top.winfo_screenheight() < 600:
        maximized = 1
        top.wm_minsize(300, 150)
    else:
        maximized = 0
        top.wm_minsize(400, 200)
    try:
        wm_set_icon(top, app.dataloader.findIcon())
    except: pass
    viewer = tkHTMLViewer(top)
    viewer.app = app
    ##print doc, help_html_index
    viewer.home = help_html_index
    viewer.display(doc)
    wm_map(top, maximized=maximized)
    return viewer

