########################################################################
#
# File Name:            Uuid.py
#
# Documentation:        http://docs.ftsuite.com/4Suite/Uuid.py.html
#
"""
A utility to generate Universally-Unique IDs (UUIDS) with ideas taken from
the code used by e2fsprogs.
WWW: http://4suite.org/4Suite         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import os, socket, string, whrandom

try:
    dev_rand = open('/dev/urandom', 'r')
    rng = None
except:
    dev_rand = None
    rng = whrandom.whrandom()


def GetRandomBytes(numBytes):
    """Returns numBytes random bytes from the best RNG available"""
    global dev_rand, rng
    bytes = ''
    if dev_rand:
        while numBytes > 0:
            b = dev_rand.read(numBytes)
            bytes = bytes + b
            numBytes = numBytes - len(b)
    else:
        for i in range(numBytes):
            bytes = bytes + chr(rng.randint(0, 255))
    return bytes


def GetEthernetNode():
    """Returns a single 4-byte string with the Ethernet node"""
    ip_list = string.split(socket.gethostbyaddr(socket.gethostname())[2][0],'.')
    result = ''
    for segment in ip_list:
        result = result + chr(int(segment))
    return result


def GenerateUuid():
    result = GetRandomBytes(16)
    result = result[:6] + chr((ord(result[6]) & 0x4F) | 0x40) + result[7:8] + chr((ord(result[8]) & 0xBF) | 0x80) + result[9:]

    res = 0L
    for i in range(16):
        res = (res << 8) + ord(result[i] )

    return res



def UuidAsString(uuid):

    newUuid = ''
    curUuid = uuid
    for ctr in range(16):
        num = int(curUuid & 0xF)
        newChar = chr(num)
        curUuid = curUuid >> 8
        newUuid = newChar + newUuid

    uuid = newUuid

    result = ''
    #This could of course be a function, but the overhead is undesirable
    mult = 0x1000000L
    num = 0
    ix = 0
    while mult:
        num = num + mult * ord(uuid[ix])
        mult = mult / 0x100
        ix = ix + 1
    result = result + hex(num)[2:-1] + '-'
    mult = 0x100
    num = 0
    while mult:
        num = num + mult * ord(uuid[ix])
        mult = mult / 0x100
        ix = ix + 1
    result = result + hex(num)[2:] + '-'
    mult = 0x100
    num = 0
    while mult:
        num = num + mult * ord(uuid[ix])
        mult = mult / 0x100
        ix = ix + 1
    result = result + hex(num)[2:] + '-'
    mult = 0x100
    num = 0
    while mult:
        num = num + mult * ord(uuid[ix])
        mult = mult / 0x100
        ix = ix + 1
    result = result + hex(num)[2:] + '-'
    mult = 0x1000000L
    num = 0
    while mult:
        num = num + mult * ord(uuid[ix])
        mult = mult / 0x100
        ix = ix + 1
    result = result + hex(num)[2:-1]
    mult = 0x100
    num = 0
    while mult:
        num = num + mult * ord(uuid[ix])
        mult = mult / 0x100
        ix = ix + 1
    result = result + hex(num)[2:]
    return string.lower(result)


def CompareUuids(u1, u2):
    return cmp(string.upper(u1), string.upper(u1))

