#ifndef DS_H
#define DS_H

#include <stdlib.h>


/***************  Lists ***************/

typedef struct ListElmt_ {

void               *data;
struct ListElmt_   *next;

} ListElmt;

typedef struct List_ {

int                size;

int                (*match)(const void *key1, const void *key2);
void               (*destroy)(void *data);

ListElmt           *head;
ListElmt           *tail;

} List;

void list_init(List *list, void (*destroy)(void *data));

void list_destroy(List *list);

int list_ins_next(List *list, ListElmt *element, const void *data);

int list_rem_next(List *list, ListElmt *element, void **data);

#define list_size(list) ((list)->size)

#define list_head(list) ((list)->head)

#define list_tail(list) ((list)->tail)

#define list_is_head(list, element) ((element) == (list)->head ? 1 : 0)

#define list_is_tail(element) ((element)->next == NULL ? 1 : 0)

#define list_data(element) ((element)->data)

#define list_next(element) ((element)->next)

/***************  Stacks ***************/

typedef List Stack;

#define _stack_init list_init

#define _stack_destroy list_destroy

int _stack_push(Stack *stack, const void *data);

int _stack_pop(Stack *stack, void **data);

#define _stack_peek(stack) ((stack)->head == NULL ? NULL : (stack)->head->data)

#define _stack_size list_size



/***************  Sets ***************/

typedef List Set;

void set_init(Set *set, int (*match)(const void *key1, const void *key2),
   void (*destroy)(void *data));

#define set_destroy list_destroy

int set_insert(Set *set, const void *data);

int set_remove(Set *set, void **data);

int set_union(Set *setu, const Set *set1, const Set *set2);

int set_intersection(Set *seti, const Set *set1, const Set *set2);

int set_difference(Set *setd, const Set *set1, const Set *set2);

int set_is_member(const Set *set, const void *data);

int set_is_subset(const Set *set1, const Set *set2);

int set_is_equal(const Set *set1, const Set *set2);

#define set_size(set) ((set)->size)


ListElmt *list_find(List *l, void *target, int (*cmp)(const void *target, const void *candidate));
int list_find_remove(List *l, void *target, void **data, int (*cmp)(const void *target, const void *candidate));
void list_foreach(List *l, void (*func)(void *data));


/***************  Chained Hashes ***************/

typedef struct CHTbl_ {

int                buckets;

int                (*hash)(const void *key);
int                (*match)(const void *key1, const void *key2);
void               (*destroy)(void *data);

int                size;
List               *table;

} CHTbl;

int chtbl_init(CHTbl *htbl, int buckets,
               int (*hash)(const void *key),
               int (*match)(const void *key1, const void *key2),
               void (*destroy)(void*data));

void chtbl_destroy(CHTbl *htbl);

int chtbl_insert(CHTbl *htbl, const void *data);

int chtbl_remove(CHTbl *htbl, void **data);

int chtbl_lookup(const CHTbl *htbl, void **data);

#define chtbl_size(htbl) ((htbl)->size)


#endif
