#include "Python.h"
#include "domlette.h"

/*Initialize the a new Node*/
void Node_INIT(PyNodeObject *node,
                 PyDocumentObject *ownerDocument)
{
  node->nodeData.parentNode = Py_None;
  Py_INCREF(Py_None);
  node->nodeData.ownerDocument = (PyObject*)ownerDocument;
  Py_XINCREF(ownerDocument);
}

/*Release a Node*/
void Node_ReleaseNode(PyNodeObject *node)
{
  if PyDocument_Check(node)
  {
    Document_ReleaseNode((PyDocumentObject *)node);
  }
  else if PyElement_Check(node)
  {
    Element_ReleaseNode((PyElementObject *)node);
  }
  else if PyText_Check(node)
  {
    Text_ReleaseNode((PyTextObject *)node);
  }
  else if PyAttr_Check(node)
  {
    Attr_ReleaseNode((PyAttrObject *)node);
  }
  else if PyProcessingInstruction_Check(node)
  {
    ProcessingInstruction_ReleaseNode((PyProcessingInstructionObject *)node);
  }
  else if PyComment_Check(node)
  {
    Comment_ReleaseNode((PyCommentObject *)node);
  }

  Py_XDECREF(node->nodeData.parentNode);
  Py_XDECREF(node->nodeData.ownerDocument);


  /*Probably not needed*/
  node->nodeData.parentNode = NULL;
  node->nodeData.ownerDocument = NULL;
}

PyNodeObject *Node_AppendChild(PyNodeObject *self, PyNodeObject *child)
{
  if PyDocument_Check(self)
  {
    return Document_AppendChild((PyDocumentObject *)self,child);
  } else if PyElement_Check(self) {
    return Element_AppendChild((PyElementObject *)self,child);
  }
  return NULL;
}


/*
    Start the external interface

*/



PyObject *PyNode_normalize(PyObject * self, PyObject * args) {
  Py_INCREF(Py_None);
  return Py_None;
}

PyObject *PyNode_hasChildNodes(PyObject * self, PyObject * args) {

  PyObject *rt;

  if (PyDocument_Check(self) && PyList_GET_SIZE(((PyDocumentObject *)self)->documentData.childNodes)) {
    rt = Py_True;
  } else if(PyElement_Check(self) && PyList_GET_SIZE(((PyElementObject *)self)->elementData.childNodes)) {
    rt = Py_True;
  } else if(PyAttr_Check(self)) {
    rt = Py_True;
  } else {
    rt = Py_False;
  }
  Py_INCREF(rt);
  return rt;
}

PyObject *PyNode_removeChild(PyObject *self,PyObject *args) {

  int index = -1;
  int ctr;
  PyObject *children;
  PyObject *removeChild;

  /*Only docs and elements*/
  if (PyDocument_Check(self)) {
    children = ((PyDocumentObject *)self)->documentData.childNodes; 
  } else if (PyElement_Check(self)){
    children = ((PyElementObject *)self)->elementData.childNodes; 
  } else {
    PyErr_SetString(ErrorObject, "HIERARCHY_REQUEST_ERROR");
    return NULL;
  }
  
  if(!PyArg_ParseTuple(args,"O:removeChild",&removeChild)) 
    return NULL;


  for (ctr=0;ctr <  PyList_GET_SIZE(children);ctr++) {
    if (PyList_GET_ITEM(children,ctr) == removeChild) {
      index = ctr;
      break;
    }
  }

  if (index == -1) {
    PyErr_SetString(ErrorObject, "HIERARCHY_REQUEST_ERROR");
    return NULL;
  }
  
  PySequence_DelItem(children, index);

  Py_INCREF(removeChild);
  return removeChild;
}


PyObject *PyNode_isSameNode(PyObject *self, PyObject *args)
{
  PyObject *other;

  if(!PyArg_ParseTuple(args,"O:other", &other)) 
    return NULL;

  return PyInt_FromLong(self == other);
}



/*Used by the all of the types as helpers */
void node_dealloc(PyNodeObject *node)
{
  PyMem_DEL(node);
}

PyObject *node_getattr(PyNodeObject *self, char *name,struct PyMethodDef methods[])
{
  PyObject * rt = NULL;
  int temp;
  PyObject *pNode = NULL;
  int pNodeIndex = -1;
  PyObject *childNodes;

  switch(name[0]) {
  case 'c':
    {
      if (!strcmp(name,"childNodes")) {
    rt = g_emptyChildNodes;
      }
      break;
    }
  case 'n':
    {
      if (!strcmp(name,"nodeValue")) {
    rt = Py_None;
      }
      else if (!strcmp(name,"namespaceURI")) {
    rt = Py_None;
      }
      else if (!strcmp(name,"nextSibling")) {
    /*Calculate this*/
    pNode = self->nodeData.parentNode;
    if (PyDocument_Check(pNode)) {
      childNodes = ((PyDocumentObject *)pNode)->documentData.childNodes;
    } else if (PyElement_Check(pNode)) {
      childNodes = ((PyElementObject *)pNode)->elementData.childNodes;
    } else {
      Py_INCREF(Py_None);
      return Py_None;
    }
    for (temp = 0;temp < PyList_GET_SIZE(childNodes);temp ++) {
      if ((PyNodeObject *)PyList_GET_ITEM(childNodes,temp) == self) {
        pNodeIndex = temp;
        break;
      }
    }
    if (pNodeIndex == -1) {
      /*Through error????*/
      Py_INCREF(Py_None);
      return Py_None;
    }
    if (pNodeIndex == PyList_GET_SIZE(childNodes) - 1) {
      /*End of the list*/
      rt = Py_None;
    } else {
      rt = PyList_GET_ITEM(childNodes,pNodeIndex+1);
    }
      }
      break;
    }
  case 'l':
    {
      if (!strcmp(name,"localName")) {
    rt = Py_None;
      }
      else if (!strcmp(name,"lastChild")) {
    rt = Py_None;
      }
      break;
    }
  case 'a':
    {
      if (!strcmp(name,"attributes")) {
	rt = g_emptyAttributes;
      }
      break;
    }
  default:
    {
      if (!strcmp(name,"prefix")) {
    rt = Py_None;
      }
      else if (!strcmp(name,"parentNode")) {
    rt = self->nodeData.parentNode;
      }
      else if (!strcmp(name,"previousSibling")) {
    /*Calculate this*/
    pNode = self->nodeData.parentNode;
    if (PyDocument_Check(pNode)) {
      childNodes = ((PyDocumentObject *)pNode)->documentData.childNodes;
    } else if (PyElement_Check(pNode)) {
      childNodes = ((PyElementObject *)pNode)->elementData.childNodes;
    } else {
      Py_INCREF(Py_None);
      return Py_None;
    }
    for (temp = 0;temp < PyList_GET_SIZE(childNodes);temp ++) {
      if ((PyNodeObject *)PyList_GET_ITEM(childNodes,temp) == self) {
        pNodeIndex = temp;
        break;
      }
    }
    if (pNodeIndex == -1) {
      /*Through error????*/
      Py_INCREF(Py_None);
      return Py_None;
    }
    if (pNodeIndex == 0) {
      /*Beginning of the list*/
      rt = Py_None;
    } else {
      rt = PyList_GET_ITEM(childNodes,pNodeIndex-1);
    }
      }
      else if (!strcmp(name,"ownerDocument")) {
    rt = self->nodeData.ownerDocument;
      }
      else if (!strcmp(name,"firstChild")) {
    rt = Py_None;
      }
      else if (!strcmp(name,"docIndex")) {
    rt = PyLong_FromLong(self->nodeData.docIndex);
      }
      break;
    }
  }
  if (rt != NULL) {
    Py_INCREF(rt);
    return rt;
  }

  return Py_FindMethod(methods, (PyObject *)self, name);
}


