############################################################################
#
# File Name: 		Dictionary.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Dictionary.py.html
#

"""
Base class for all dictionaries
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants

class Dictionary:

    def __init__(self,db,did):
        if did is None:
            #New Dictionary
            self.__dict__['_did'] = 0
        else:
            #Recreated dictionary
            self.__dict__['_did'] = did

        # See if we are in a transaction
        self.__dict__['_db'] = db
        if self._db:
            self.__dict__['_tx'] = self._db.current()
        else:
            self.__dict__['_tx'] = None

        if self._tx:
            if did:
                self._tx._4ods_registerModifiedPersistentObject(self)
            else:
                self._tx._4ods_registerNewPersistentObject(self)
        self.__dict__['_deleted'] = 0

    def delete(self,recurse=0):
        if self._tx:
            self._tx._4ods_deletePersistentObject(self)
        self.__dict__['_deleted'] = 1

    def _4ods_getId(self):
        return self._did

    def _4ods_setDid(self, did):
        self.__dict__['_did'] = did

    def _4ods_getOdsType(self):
        return Constants.Types.DICTIONARY_COLLECTION


    _extents = ()
    _localExtents = ()

