import Oif
import OifParserBase

from OifParserBase import SyntaxException
from OifParserBase import InternalException
from OifParserBase import PrintSyntaxException
from OifParserBase import PrintInternalException

class OifParseTreeMapping(OifParserBase.OifParserBase):
	def __init__(self):
		OifParserBase.OifParserBase.__init__(self)
	def OIF_file(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'OIF_FILE'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def object_def_list(self, arg0 = None, arg1 = None):
		newNode = {}
		newNode['TYPE'] = 'OBJECT_DEF_LIST'
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def object_def(self, arg0 = None, arg1 = None, arg2 = None, arg3 = None, arg4 = None, arg5 = None):
		newNode = {}
		newNode['TYPE'] = 'OBJECT_DEF'
		if arg5 == '%%FT-NT%%':
			newNode[5] = self.pop()
		else:
			newNode[5] = arg5
		if arg4 == '%%FT-NT%%':
			newNode[4] = self.pop()
		else:
			newNode[4] = arg4
		if arg3 == '%%FT-NT%%':
			newNode[3] = self.pop()
		else:
			newNode[3] = arg3
		if arg2 == '%%FT-NT%%':
			newNode[2] = self.pop()
		else:
			newNode[2] = arg2
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def physically_near_to(self, arg0 = None, arg1 = None, arg2 = None):
		newNode = {}
		newNode['TYPE'] = 'PHYSICALLY_NEAR_TO'
		if arg2 == '%%FT-NT%%':
			newNode[2] = self.pop()
		else:
			newNode[2] = arg2
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def initialization(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'INITIALIZATION'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def attribute_list(self, arg0 = None, arg1 = None, arg2 = None):
		newNode = {}
		newNode['TYPE'] = 'ATTRIBUTE_LIST'
		if arg2 == '%%FT-NT%%':
			newNode[2] = self.pop()
		else:
			newNode[2] = arg2
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def attribute(self, arg0 = None, arg1 = None):
		newNode = {}
		newNode['TYPE'] = 'ATTRIBUTE'
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def value_list(self, arg0 = None, arg1 = None, arg2 = None):
		newNode = {}
		newNode['TYPE'] = 'VALUE_LIST'
		if arg2 == '%%FT-NT%%':
			newNode[2] = self.pop()
		else:
			newNode[2] = arg2
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def value(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'VALUE'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def literal(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'LITERAL'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def struct_value(self, arg0 = None, arg1 = None, arg2 = None):
		newNode = {}
		newNode['TYPE'] = 'STRUCT_VALUE'
		if arg2 == '%%FT-NT%%':
			newNode[2] = self.pop()
		else:
			newNode[2] = arg2
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def array_value(self, arg0 = None, arg1 = None, arg2 = None):
		newNode = {}
		newNode['TYPE'] = 'ARRAY_VALUE'
		if arg2 == '%%FT-NT%%':
			newNode[2] = self.pop()
		else:
			newNode[2] = arg2
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def indexed_value_list(self, arg0 = None, arg1 = None, arg2 = None, arg3 = None):
		newNode = {}
		newNode['TYPE'] = 'INDEXED_VALUE_LIST'
		if arg3 == '%%FT-NT%%':
			newNode[3] = self.pop()
		else:
			newNode[3] = arg3
		if arg2 == '%%FT-NT%%':
			newNode[2] = self.pop()
		else:
			newNode[2] = arg2
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def index(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'INDEX'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def collection_value(self, arg0 = None, arg1 = None, arg2 = None):
		newNode = {}
		newNode['TYPE'] = 'COLLECTION_VALUE'
		if arg2 == '%%FT-NT%%':
			newNode[2] = self.pop()
		else:
			newNode[2] = arg2
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def fieldname(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'FIELDNAME'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def classname(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'CLASSNAME'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def object_tag(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'OBJECT_TAG'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def boolean_literal(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'BOOLEAN_LITERAL'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def character_literal(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'CHARACTER_LITERAL'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def integer_literal(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'INTEGER_LITERAL'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def float_literal(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'FLOAT_LITERAL'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def string_literal(self, arg0 = None):
		newNode = {}
		newNode['TYPE'] = 'STRING_LITERAL'
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)

	def scoped_name(self, arg0 = None, arg1 = None, arg2 = None):
		newNode = {}
		newNode['TYPE'] = 'SCOPED_NAME'
		if arg2 == '%%FT-NT%%':
			newNode[2] = self.pop()
		else:
			newNode[2] = arg2
		if arg1 == '%%FT-NT%%':
			newNode[1] = self.pop()
		else:
			newNode[1] = arg1
		if arg0 == '%%FT-NT%%':
			newNode[0] = self.pop()
		else:
			newNode[0] = arg0
		self.push(newNode)


if __name__ == '__main__':
	from Ft.Lib import DumpBgMapping
	import sys
	rt = []
	p = OifParseTreeMapping()
	if len(sys.argv)==2:
		l = open(sys.argv[1],'r').read()
	else:
		l = raw_input(">>>")
	try:
		rt = p.parse(l)
		DumpBgMapping.Dump(rt)
	except ParseTreeException, e:
		PrintParseTreeException(e)
	except SyntaxException, e:
		PrintSyntaxException(e)
