import sys

class BaseElement:
    _ft_debugger_saveResults = 0
    _ft_debugger_record = -1

    def doAll(self, processor, method, args, argNames, name):
        if processor._4xslt_trace:
            argStr = ""
            for ctr in range(len(args)):
                if argNames[ctr]:
                    argStr = argStr + "%s = %s " % (argNames[ctr], args[ctr])
            if hasattr(self, 'baseUri'):
                name = name + ' Uri: %s' % self.baseUri

            if hasattr(self, '_ft_lineNumber') and self._ft_lineNumber != '??':
                name = name + ' Line: %s Col %s' % (self._ft_lineNumber, self._ft_columnNumber)

            processor._4xslt_traceStream.write("%s Begin %s %s\n" % (processor._4xslt_traceIndent*'  ',
                                                                     name,
                                                                     argStr))
            processor._4xslt_traceIndent = processor._4xslt_traceIndent + 1
            rt =  apply(method,(self,) + args)
            processor._4xslt_traceIndent = processor._4xslt_traceIndent - 1
            processor._4xslt_traceStream.write("%s End %s %s\n" % (processor._4xslt_traceIndent*'  ',
                                                                   name,
                                                                   argStr))

        elif processor._4xslt_debug:
            if self._ft_debugger_record:
                res = processor._ft_debug_controller.startCall(self,args[0])

            record = self._ft_debugger_record
            if self._ft_debugger_record > 0:
                self._ft_debugger_record = self._ft_debugger_record - 1
        
            rt =  apply(method,(self,) + args)

            if record:
                processor._ft_debug_controller.endCall(self,args[0],res,self._ft_debugger_saveResults and rt or None)
        else:
            rt =  apply(method,(self,) + args)
        return rt        



from xml.xslt import Processor
class ExtendedProcessor(BaseElement,Processor.Processor):
    _4xslt_traceIndent = 0
    _4xslt_traceStream = sys.stdout
    _ft_debugger_record = 1
    def applyTemplates(self, context, mode, params=None):
        return self.doAll(self,
                          Processor.Processor.applyTemplates,
                          (context,mode,params),
                          ('context','mode','params'),
                          'Processor.ApplyTemplates')


    def applyImports(self, context, mode=None, params=None):
        return self.doAll(self,
                          Processor.Processor.applyImports,
                          (context,mode,params),
                          ('context','mode','params'),
                          'Processor.ApplyImports')

    def callTemplate(self, name, context, params, new_level=1):
        return self.doAll(self,
                          Processor.Processor.callTemplate,
                          (name,context,params,new_level),
                          ('name','context','params',None),
                          'Processor.CallTemplate')




from xml.xslt import TemplateElement
class ExtendedTemplateElement(BaseElement,TemplateElement.TemplateElement):

    def instantiate(self, context, processor, params=None, new_level=1):
        name = "TemplateElement"
        if self._match:
            name = name + " match='%s'" % str(self._match)
        if self._mode:
            name = name + " mode='%s'" % str(self._mode)
        if self._name != ('',''):
            name = name + " name='%s'" % str(self._name)
        return self.doAll(processor,
                          TemplateElement.TemplateElement.instantiate,
                          (context,processor,params,new_level),
                          ('context',None,'params',None),
                          name)


from xml.xslt import IfElement
class ExtendedIfElement(BaseElement,IfElement.IfElement):

    def instantiate(self, context, processor, new_level=1):
        name = "xsl:if test='%s'" % str(self._test)
        return self.doAll(processor,
                          IfElement.IfElement.instantiate,
                          (context,processor,new_level),
                          ('context',None,None),
                          name)
from xml.xslt import ChooseElement
class ExtendedChooseElement(BaseElement,ChooseElement.ChooseElement):

    def instantiate(self, context, processor, new_level=1):
        name = "xsl:choose"
        return self.doAll(processor,
                          ChooseElement.ChooseElement.instantiate,
                          (context,processor,new_level),
                          ('context',None,None),
                          name)

from xml.xslt import WhenElement
class ExtendedWhenElement(BaseElement,WhenElement.WhenElement):

    def instantiate(self, context, processor, new_level=1):
        name = "xsl:when test='%s'" % self._test
        return self.doAll(processor,
                          WhenElement.WhenElement.instantiate,
                          (context,processor,new_level),
                          ('context',None,None),
                          name)
from xml.xslt import OtherwiseElement
class ExtendedOtherwiseElement(BaseElement,OtherwiseElement.OtherwiseElement):

    def instantiate(self, context, processor, new_level=1):
        name = "xsl:otherwise"
        return self.doAll(processor,
                          OtherwiseElement.OtherwiseElement.instantiate,
                          (context,processor,new_level),
                          ('context',None,None),
                          name)


class ExtendedSimpleElement(BaseElement):
    
    def instantiate(self, context, processor):
        name = self.getName()
        return self.doAll(processor,
                          self._ft_actualClass.instantiate,
                          (context,processor),
                          ('context',None),
                          name)


from xml.xslt import LiteralElement
class ExtendedLiteralElement(ExtendedSimpleElement,LiteralElement.LiteralElement):
    _ft_actualClass = LiteralElement.LiteralElement
    def getName(self):
        self._ft_actualClass = self.__class__.__bases__[1]
        return "LiteralElement: %s" % self.nodeName

from xml.xslt import ValueOfElement
class ExtendedValueOfElement(ExtendedSimpleElement,ValueOfElement.ValueOfElement):
    def getName(self):
        self._ft_actualClass = self.__class__.__bases__[1]
        return "xsl:value-of select='%s'" % str(self._select)

from xml.xslt import AttributeElement
class ExtendedAttributeElement(ExtendedSimpleElement,AttributeElement.AttributeElement):
    def getName(self):
        self._ft_actualClass = self.__class__.__bases__[1]
        return "xsl:attribute name='%s'" % str(self._name)

from xml.xslt import CommentElement
class ExtendedCommentElement(ExtendedSimpleElement,CommentElement.CommentElement):
    def getName(self):
        self._ft_actualClass = self.__class__.__bases__[1]
        return "xsl:comment" 

from xml.xslt import CopyElement
class ExtendedCopyElement(ExtendedSimpleElement,CopyElement.CopyElement):
    def getName(self):
        self._ft_actualClass = self.__class__.__bases__[1]
        return "xsl:copy" 

from xml.xslt import CopyOfElement
class ExtendedCopyOfElement(ExtendedSimpleElement,CopyOfElement.CopyOfElement):
    def getName(self):
        self._ft_actualClass = self.__class__.__bases__[1]
        return "xsl:copy-of select='%s'" % str(self._select) 

from xml.xslt import ElementElement
class ExtendedElementElement(ExtendedSimpleElement,ElementElement.ElementElement):
    def getName(self):
        self._ft_actualClass = self.__class__.__bases__[1]
        return "xsl:element name='%s'" % str(self._name) 

from xml.xslt import ForEachElement
class ExtendedForEachElement(ExtendedSimpleElement,ForEachElement.ForEachElement):
    def getName(self):
        self._ft_actualClass = self.__class__.__bases__[1]
        return "xsl:for-each select='%s'" % str(self._select) 

from xml.xslt import ProcessingInstructionElement
class ExtendedProcessingInstructionElement(ExtendedSimpleElement,ProcessingInstructionElement.ProcessingInstructionElement):
    def getName(self):
        self._ft_actualClass = self.__class__.__bases__[1]
        return "xsl:processing-instruction"

newMappings = {'template':ExtendedTemplateElement,
               'if':ExtendedIfElement,
               'value-of':ExtendedValueOfElement,
               'choose':ExtendedChooseElement,
               'attribute':ExtendedAttributeElement,
               'comment':ExtendedCommentElement,
               'copy':ExtendedCopyElement,
               'copy-of':ExtendedCopyOfElement,
               'element':ExtendedElementElement,
               'for-each':ExtendedForEachElement,
               'otherwise':ExtendedOtherwiseElement,
               'processing-instruction':ExtendedProcessingInstructionElement,
               'when':ExtendedWhenElement,
               }

def GetMappings():
    from xml.xslt import XSL_NAMESPACE
    import StylesheetReader
    g_traceMappings = StylesheetReader.g_mappings.copy()
    g_traceMappings[XSL_NAMESPACE].update(newMappings)


    StylesheetReader.LiteralElement = ExtendedLiteralElement

    return g_traceMappings





