import os

#
#Note: While testing it might be useful to use
#
#export TRACEOUT=4ODS:4Suite.PgDatabase
#export TRACEOUT_FLAGS=LABEL
#
#Requires the database to be set up with the schema from varsity1.odl or varsity2.odl
#
#Typical test process:
#
#python ../Tools/4odb_destroy.py test
#python ../Tools/4odb_create.py test
#python basic_test1.py
#


from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import Database
import os,sys
import test_util

odl_string = """
module Test {

class Professor;

class Student (extent students)
{
	attribute string name;
	attribute unsigned short student_id;
        attribute short age;
        attribute double weight;
	attribute string ssn;
	relationship Professor learns_from inverse Test::Professor :: teaches;
};

class Professor
{
	attribute string name;
	attribute unsigned short employee_id;
	attribute string ssn;
	relationship ::Test::Student teaches inverse Student :: learns_from;
};
};

"""
#"


DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')
        pass

def _Test(tester):

    tester.startGroup('Basic Test %s driver' % tester.ods_driver_name)

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        from Test import Professor
        from Test import Student
    except:
        tester.error('Error in syntax', 1)
    tester.testDone()

    reload(Professor)
    reload(Student)
    
    db = Database.Database()
    db.open(DBNAME)

    tx = db.new()
    tx.begin()

    tester.startTest('Testing Class Creation and relationship formation')

    p = Professor.new(db)
    s = Student.new(db)

    p.ssn = '666-123-1234'
    p.name = 'Eblis Einstein'

    s.ssn = '123-456-7890'
    s.name = 'Maro Faustus'

    s.age = 13
    s.weight = 1.23456

    p.form_teaches(s)

    tx.commit()
    tester.testDone()


    tester.startTest('Testing Class Loading')
    
    pid = p._4ods_getOid()
    sid = s._4ods_getOid()

    tx = db.new()
    tx.begin()

    p = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,pid)
    s = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,sid)

    tester.compare('666-123-1234', p.ssn, "Invalid SSN")
    tester.compare('Eblis Einstein', p.name, "Invalid Name")
    tester.compare(s, p.teaches, "Invalid Teaches")
    tester.compare(p, p.teaches.learns_from, "Invalid Teaches.learns_from")
    tx.abort()

    tester.testDone()

    tester.startTest('Testing Extents')

    tx = db.new()
    tx.begin()

    s = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,sid)

    ext = db.lookup('students')
    s2 = ext[-1]

    tester.testResults(s,s2,done=0,msg="Invalid Extent")
    tester.testResults(13,s2.age,done=0,msg="Invalid Age")
    tester.testResults(1.23456,round(s2.weight,5),done=0,msg="Invalid Weight")
    tx.abort()
    db.close()
    tester.testDone()
    tester.groupDone()

    return

if __name__ == '__main__':


    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1, 1)
    from Ft.Ods.StorageManager import Adapters
    tester.ods_driver_name = Adapters.g_driverName

    retVal = Test(tester)
    sys.exit(retVal)

