'''An example of 4RDF schema support'''

import xml.dom.ext
from xml.dom.ext.reader import PyExpat
reader = PyExpat.Reader()


def SchemaDemo():
    from Ft.Rdf.Drivers import Memory
    db = Memory.CreateDb('test')
    db.begin()

    from Ft.Rdf import Model, SchemaHandler, Statement
    sh = SchemaHandler.SchemaHandler()
    m = Model.Model(db, sh)

    #The model should start out with all the RDF meta-model
    print "New model seeded with RDF meta-model statements\n"
    print m.complete(None, None, None)

    #Read in the schema just as any other RDF
    schemadoc = reader.fromUri('spamschema.rdfs')

    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    
    serializer.deserialize(m, schemadoc, 'http://schema.spam.com')

    print "Model with user's RDF schema read in\n"
    print m.complete(None, None, None)

    #Read in the RDF data
    doc = reader.fromUri('spamdata.rdf')
    serializer.deserialize(m, doc, 'http://spam.com/data')

    print "Model with user's RDF data read in\n"
    print m.complete(None, None, None)

    print sh.isInstance(m, 'http://rblrebels.com/~robelee', 'http://schema.spam.com#Person')
    print sh.isInstance(m, 'http://rblrebels.com/~spartacus', 'http://schema.spam.com#Person')
    print sh.isSubClass(m, 'http://schema.spam.com#Moderator', 'http://schema.spam.com#Person')

    #Try to add a statement that violates constraints
    #represents has a range of http://schema.spam.com#Organization
    s = Statement.Statement('http://rblrebels.com/~robelee', 'http://schema.spam.com#represents', 'ILLEGAL')
    print m.complete('http://rblrebels.com/~spartacus', 'http://schema.spam.com#represents', None)
    print m.complete('http://schema.spam.com#represents', None, None)
    m.add(s)
    
    db.commit()
    xml.dom.ext.ReleaseNode(schemadoc)
    xml.dom.ext.ReleaseNode(doc)
    return


if __name__ == '__main__':
    SchemaDemo()
