from Ft.Lib.routines import FormatNumber



g_tests = [(3.45,'#.##','3.45'),
           (3.45,'###.#####','3.45'),
           (3.45,'###.0000','3.4500'),
           (3.45,'###.##;#.##','3.45'),
           (-3.45,'###.##;(#.##)','(3.45)'),
           (1234567.89,'######,###.##','1,234,567.89'),
           (1234567.901,'######,###.##','1,234,567.9'),
           (0.000008,'#0.00','0.00'),
           (.00256323814392,'0.00000','0.00256'),
           ]

def Test(tester):

    tester.startGroup("Format number")
    for num,format,exp in g_tests:
        tester.startTest("%s with %s" %(str(num),format))
        act = FormatNumber(num,format)
        tester.compare(exp,act)
        tester.testDone()
    tester.groupDone()

if __name__ == '__main__':
    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1,1)
    Test(tester)
