#! /usr/bin/env python

from xml.dom.ext.reader import PyExpat
from xml.xpath import Evaluate, NormalizeNode
from xml.xpath.Conversions import StringValue

test = '''<foo>
    <bar>normal text</bar>
    <f>f1</f>
    Free range chickens
    <bar><![CDATA[<cdatatext>]]></bar>
    <f>f2</f>
</foo>
'''


def Test(tester):
    
    tester.startTest("CDATA Conversions")
    dom = tester.test_data['reader'].fromString(test)
    NormalizeNode(dom)
    nodes = Evaluate('//bar/text()', dom)
    tester.compare(2,len(nodes))
    tester.compare('normal text',StringValue(nodes[0]))
    tester.compare('<cdatatext>',StringValue(nodes[1]))
    tester.compare('<cdatatext>',Evaluate('string(//bar[2]/text())', dom))
    tester.testDone()
