# Duncan Grisby <dgrisby@uk.research.att.com> reports dependence on the order of the false attributes in an xml-stylesheet PI

from Xslt import test_harness

source_1 = """\
<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<?xml-stylesheet type="text/xml" href="Xslt/Core/addr_book1.xsl"?>
<ADDRBOOK>
    <ENTRY ID="pa">
        <NAME>Pieter Aaron</NAME>
        <ADDRESS>404 Error Way</ADDRESS>
        <PHONENUM DESC="Work">404-555-1234</PHONENUM>
        <PHONENUM DESC="Fax">404-555-4321</PHONENUM>
        <PHONENUM DESC="Pager">404-555-5555</PHONENUM>
        <EMAIL>pieter.aaron@inter.net</EMAIL>
    </ENTRY>
</ADDRBOOK>
"""

expected_1 = """\
<html>\n  <head>\n    <meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>\n    <title>Address Book</title>\n  </head>\n  <body>\n    <h1>Tabulate Just Names and Phone Numbers</h1>\n    <table>\n      <tr>\n        <td align='center'>\n          <b>Pieter Aaron</b>\n        </td>\n        <td>(Work) 404-555-1234<br>(Fax) 404-555-4321<br>(Pager) 404-555-5555</td>\n      </tr>\n    </table>\n  </body>\n</html>"""


def Test(tester):
    tester.startGroup("xml-stylesheet PI false attr order")
    source = test_harness.FileInfo(string=source_1)
    xtest = test_harness.XsltTester(source,
                                    [],
                                    expected_1,
                                    ignorePis=0,
                                    )
    xtest.test(tester)
    tester.groupDone()

    return
