#Stefan Seefeld <seefeld@sympatico.ca> has trouble with the docbook stylesheets

import os
from Xslt import test_harness

source_1 = """\
<book>
  <chapter><title>Chapter</title>
  <sect1><title>Sect1</title>
  <sect2><title>Sect2</title>
  </sect2>
  </sect1>
  </chapter>
</book>
"""

saxon_6_0_2_expected = """\
<html><head>
      <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
   <title></title><meta name="generator" content="DocBook XSL Stylesheets V1.29"></head><body bgcolor="white" text="black" link="#0000FF" vlink="#840084" alink="#0000FF"><div class="book" id="c35b1"><div class="titlepage"><hr></div><div class="toc"><p><b>Table of Contents</b></p><dl><dt>1. <a href="#c35b1b1">Chapter</a></dt><dd><dl><dt> <a href="#c35b1b1b2">Sect1</a></dt><dd><dl><dt> <a href="#c35b1b1b2b2">Sect2</a></dt></dl></dd></dl></dd></dl></div><div id="c35b1b1" class="chapter"><div class="titlepage"><div><h2 class="title"><a name="c35b1b1"></a>Chapter 1. Chapter</h2></div></div><div class="toc"><p><b>Table of Contents</b></p><dl><dt> <a href="#c35b1b1b2">Sect1</a></dt><dd><dl><dt> <a href="#c35b1b1b2b2">Sect2</a></dt></dl></dd></dl></div><div class="sect1"><a name="c35b1b1b2"></a><div class="titlepage"><div><h2 class="title" style="clear: all"><a name="c35b1b1b2"></a><span class="title">Sect1</span></h2></div></div><div class="sect2"><a name="c35b1b1b2b2"></a><div class="titlepage"><div><h3 class="title"><a name="c35b1b1b2b2"></a><span class="title">Sect2</span></h3></div></div></div></div></div></div></body></html>"""


expected_1 = """\
<html><head>
      <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
   <title></title><meta name="generator" content="DocBook XSL Stylesheets V1.29"></head><body bgcolor="white" text="black" link="#0000FF" vlink="#840084" alink="#0000FF"><div class="book" id="c35b1"><div class="titlepage"><hr></div><div class="toc"><p><b>Table of Contents</b></p><dl><dt>1. <a href="#c35b1b1">Chapter</a></dt><dd><dl><dt> <a href="#c35b1b1b2">Sect1</a></dt><dd><dl><dt> <a href="#c35b1b1b2b2">Sect2</a></dt></dl></dd></dl></dd></dl></div><div id="c35b1b1" class="chapter"><div class="titlepage"><div><h2 class="title"><a name="c35b1b1"></a>Chapter 1. Chapter</h2></div></div><div class="toc"><p><b>Table of Contents</b></p><dl><dt> <a href="#c35b1b1b2">Sect1</a></dt><dd><dl><dt> <a href="#c35b1b1b2b2">Sect2</a></dt></dl></dd></dl></div><div class="sect1"><a name="c35b1b1b2"></a><div class="titlepage"><div><h2 class="title" style="clear: all"><a name="c35b1b1b2"></a><span class="title">Sect1</span></h2></div></div><div class="sect2"><a name="c35b1b1b2b2"></a><div class="titlepage"><div><h3 class="title"><a name="c35b1b1b2b2"></a><span class="title">Sect2</span></h3></div></div></div></div></div></div></body></html>"""


# We need to have generate-id return the same id in different runs
from xml.xslt import XsltFunctions
g_ctr = 1
g_map = {}
def GenerateId(context, nodeSet=None):
    gen_id = XsltFunctions.GenerateId(context, nodeSet)
    if g_map.has_key(gen_id):
        return g_map[gen_id]
    global g_ctr
    id = 'id%d' % g_ctr
    g_ctr = g_ctr + 1
    g_map[gen_id] = id
    return id
    
ExtFunctions = {('', 'generate-id') : GenerateId}

def Test(tester):
    tester.startGroup("Borrowed: ss_20010301")
    dir = os.path.dirname(__file__)
    dbx_dir =os.path.join(dir, 'docbook')
    if not os.access(dbx_dir, os.F_OK):
        tester.startTest('Checking for stylesheet')
        tester.warning("You need Norm Walsh's Docbook stylesheet package to run this test")
        tester.warning("You can either ignore this, or you can install dbxXXX.zip")
        tester.warning("inside the '%s' directory" % dir)
        tester.warning("where XXX is the version number, which would be at least 129.")
        tester.testDone()
        tester.groupDone()
        return 1

    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(uri='Xslt/Borrowed/docbook/html/docbook.xsl')
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    extensionModules=[__name__],
                                    )

    xtest.test(tester)
    tester.groupDone()
    return
