#from Ft.Server.Common import ResourceTypes, Schema, AclConstants
from Ft.Server.Client import FtServerClientException, Error
from Ft.Server.FtRpc import Commands

class ModelClient:
    """A Proxy that sends all commands to the server"""

    def __init__(self,connection,baseObject):
        self._connection = connection
        self._baseObject = baseObject

    def addContainer(self, container, scope=None):
        raise "Finish"

    def extractContainer(self, uri, scope=None):
        raise "Finish"

    def add(self, statements, checkSchema=1):
        Commands.RemoteRdfCommand('add',
                                  self._baseObject,
                                  (statements, checkSchema)
                                 ).send(self._connection).results

    def enableSchema(self):
        raise "Finish"

    def disableSchema(self):
        raise "Finish"

    def checkConsistency(self):
        raise "Finish"

    def remove(self, statements):
        Commands.RemoteRdfCommand('remove',
                                  self._baseObject,
                                  (statements,)
                                 ).send(self._connection).results

    def removePattern(self, subject, predicate, object,
                      statementUri=None, scope=None, **flags):
        Commands.RemoteRdfCommand('removePattern',
                                  self._baseObject,
                                  (subject, predicate, object, statementUri, scope),
                                  flags
                                  ).send(self._connection).results

    def contains(self, statement):
        raise "Finish"

    def containsPattern(self, subject, predicate, object,
                        statementUri=None, scope=None, **flags):
        raise "Finish"

    def statements(self, scope=None):
        raise "Finish"

    def size(self, scope=None):
        raise "Finish"

    def complete(self, subject, predicate, object,
                 statementUri=None, scope=None, **flags):
        return Commands.RemoteRdfCommand('complete',
                                         self._baseObject,
                                         (subject, predicate, object, statementUri, scope),
                                         flags
                                         ).send(self._connection).results


    def exclude(self, subject, predicate, object,
                statementUri=None, scope=None, **flags):
        raise "Finish"

    def generateUri(self):
        raise "Finish"

    def versaQuery(self, queryStr, nsMapping=None, varBindings=None, scope=None):
        nsMapping = nsMapping or None
        varBindings = varBindings or {}
        return Commands.RemoteRdfCommand('versaQuery',
                                         self._baseObject,
                                         (queryStr, nsMapping, varBindings, scope),
                                         {}
                                         ).send(self._connection).results

    def versaQueryRaw(self, queryStr, nsMapping=None, varBindings=None, scope=None):
        nsMapping = nsMapping or None
        varBindings = varBindings or {}
        return Commands.RemoteRdfCommand('versaQueryRaw',
                                         self._baseObject,
                                         (queryStr, nsMapping, varBindings, scope),
                                         {}
                                         ).send(self._connection).results

