import os, tempfile

from Ft.Lib.CommandLine import CommandLineTestUtil
from Ft.Lib.Uri import OsPathToUri
from Ft.Server.Client import Core
from Server.Client.Core import test_helper

import test_prime

FIRST_DOCUMENT = '/' + test_prime.BASE_CONTAINER + '/doc1'
FIRST_DOCUMENT_ALIAS = '/' + test_prime.BASE_CONTAINER + '/doca1'

SECOND_DOCUMENT = '/' + test_prime.BASE_CONTAINER + '/doc2'
SECOND_DOCUMENT_ALIAS = '/' + test_prime.BASE_CONTAINER + '/doca2'


def val1(tester):
    repo = test_helper.GetRepo(tester)
    try:
        if not repo.hasResource(FIRST_DOCUMENT):
            return 0
        if not repo.hasResource(FIRST_DOCUMENT_ALIAS):
            return 0
        tester.compare(DOC1,repo.fetchResource(FIRST_DOCUMENT).getContent())
        return 1

    finally:
        repo.txRollback()

def val2(tester):
    repo = test_helper.GetRepo(tester)
    try:
        if not repo.hasResource(SECOND_DOCUMENT):
            return 0
        if not repo.hasResource(SECOND_DOCUMENT_ALIAS):
            return 0
        tester.compare(DOC1,repo.fetchResource(SECOND_DOCUMENT).getContent())
        return 1
    finally:
        repo.txRollback()

def Init(repo):
    for p in [FIRST_DOCUMENT,
              FIRST_DOCUMENT_ALIAS,
              SECOND_DOCUMENT,
              SECOND_DOCUMENT_ALIAS]:
        if repo.hasResource(p):
            repo.deleteResource(p,traverseAliases = 0)


def Test(tester):

    test_prime.InitRepo(tester,Init,['4ss','create','document'])

    baseConfig = {'host':tester.test_data['ftrpc-host'],
                  'port':tester.test_data['ftrpc-port'],
                  'username':tester.test_data['userName'],
                  'password':tester.test_data['password'],
                  }

    tempFiles = []
    #Create a container from file
    fileName = tempfile.mktemp()
    f = open(fileName,'w')
    f.write(DOC1)
    f.close()
    tempFiles.append(fileName)
    fileNameUri = OsPathToUri(fileName)

    try:
        tr1 = CommandLineTestUtil.TestRun('Basic Create',
                                          baseConfig,
                                          [FIRST_DOCUMENT, fileNameUri,
                                           FIRST_DOCUMENT_ALIAS],
                                          validationFunc = val1)

        #Create a doc from stdin
        tr2 = CommandLineTestUtil.TestRun('STDIN Create',
                                          baseConfig,
                                          [SECOND_DOCUMENT,'-',
                                           SECOND_DOCUMENT_ALIAS],
                                          validationFunc = val2,input=DOC1)

        #Create a doc that already exist
        tr3 = CommandLineTestUtil.TestRun('Re-Create',
                                          baseConfig,
                                          [FIRST_DOCUMENT,fileNameUri],
                                          expected_3%FIRST_DOCUMENT)


        t = CommandLineTestUtil.Test('4ss create document',[tr1,tr2,tr3])

        return t.test(tester)
    finally:
        for f in tempFiles:
            os.unlink(f)

DOC1 = """<dummy/>"""

expected_3 = "Path %s is already in the repository\n"

