########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Fetch/Group.py,v 1.9 2004/09/23 20:53:29 mbrown Exp $
"""
Implementation of '4ss fetch group' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command prints information about a Group resource in \
a 4Suite repository. It lists the group's members and summarizes its \
ACL. If necessary, you will be prompted first for credentials and \
access info to connect to the repository."""

import sys

from Ft.Server.Client import FtServerClientException
from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import AclConstants, ResourceTypes


def Run(options, args):
    repo = CommandUtil.GetRepository(options, '4ss.fetch.group')
    if repo is not None:
        name = args['groupName']
        try:
            group = repo.fetchUserOrGroupByName(name)
            if group is not None:
                if group.isResourceType(ResourceTypes.ResourceType.GROUP):
                    CommandUtil.WritePreamble("Group %s:" % group.getName())
                    print "Path: %s" % group.getPath()
                    print "Read ACL: %s" % group.getAcl(AclConstants.READ_ACCESS)
                    print "Write ACL: %s" % group.getAcl(AclConstants.WRITE_ACCESS)
                    print "Members:"
                    for m in group.getMembers():
                        print "  %s" % m.getName()
                else:
                    #FIXME: use FtServerClientException?
                    sys.stderr.write("%s is a User, not a Group.\n" % name)
                    sys.stderr.flush()
            else:
                #FIXME: use FtServerClientException?
                sys.stderr.write("Group %s does not exist.\n" % name)
                sys.stderr.flush()
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('group',
                          "Print information about a Group in a repository",
                          'developers',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('groupName',
                                                                  'the name of the Group',
                                                                  str),
                                       ],
                          fileName = __file__,
                          )
    return cmd
