# AsynQueue:
# Asynchronous task queueing based on the Twisted framework, with task
# prioritization and a powerful worker/manager interface.
#
# Copyright (C) 2006-2007 by Edwin A. Suominen, http://www.eepatents.com
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
# 
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the file COPYING for more details.
# 
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 51
# Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

"""
Unit tests for asynqueue.processworker
"""

import mock, processworker


JOB_ID = 1

JOB_CODE = """
def test(a, b, c=0):
    return a + 2*b + 3*c
"""


class Test_Parent(mock.TestCase):
    def setUp(self):
        self.mgr = processworker.ChildManager()

    def tearDown(self):
        return self.mgr.shutdown()

    def test_spawnChild(self):
        def check(result):
            process, root = result
            self.mgr.children = {1:process}
            d = root.callRemote('newJob', JOB_ID, JOB_CODE)
            d.addCallback(self.failUnlessEqual, (True, ['test']))
            return d
        
        return self.mgr.spawnChild().addCallback(check)
