# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
import uuid

from .. import models


class TaskOperations(object):
    """TaskOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An objec model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def add(
            self, job_id, task, task_add_options=None, custom_headers=None, raw=False, **operation_config):
        """Adds a task to the specified job.

        :param job_id: The id of the job to which the task is to be added.
        :type job_id: str
        :param task: The task to be added.
        :type task: :class:`TaskAddParameter
         <azure.batch.models.TaskAddParameter>`
        :param task_add_options: Additional parameters for the operation
        :type task_add_options: :class:`TaskAddOptions
         <azure.batch.models.TaskAddOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if task_add_options is not None:
            timeout = task_add_options.timeout
        client_request_id = None
        if task_add_options is not None:
            client_request_id = task_add_options.client_request_id
        return_client_request_id = None
        if task_add_options is not None:
            return_client_request_id = task_add_options.return_client_request_id
        ocp_date = None
        if task_add_options is not None:
            ocp_date = task_add_options.ocp_date

        # Construct URL
        url = '/jobs/{jobId}/tasks'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(task, 'TaskAddParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [201]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def list(
            self, job_id, task_list_options=None, custom_headers=None, raw=False, **operation_config):
        """Lists all of the tasks that are associated with the specified job.

        :param job_id: The id of the job.
        :type job_id: str
        :param task_list_options: Additional parameters for the operation
        :type task_list_options: :class:`TaskListOptions
         <azure.batch.models.TaskListOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`CloudTaskPaged <azure.batch.models.CloudTaskPaged>`
        """
        filter = None
        if task_list_options is not None:
            filter = task_list_options.filter
        select = None
        if task_list_options is not None:
            select = task_list_options.select
        expand = None
        if task_list_options is not None:
            expand = task_list_options.expand
        max_results = None
        if task_list_options is not None:
            max_results = task_list_options.max_results
        timeout = None
        if task_list_options is not None:
            timeout = task_list_options.timeout
        client_request_id = None
        if task_list_options is not None:
            client_request_id = task_list_options.client_request_id
        return_client_request_id = None
        if task_list_options is not None:
            return_client_request_id = task_list_options.return_client_request_id
        ocp_date = None
        if task_list_options is not None:
            ocp_date = task_list_options.ocp_date

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = '/jobs/{jobId}/tasks'
                path_format_arguments = {
                    'jobId': self._serialize.url("job_id", job_id, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if select is not None:
                    query_parameters['$select'] = self._serialize.query("select", select, 'str')
                if expand is not None:
                    query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int')
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
            if self.config.generate_client_request_id:
                header_parameters['client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters)
            response = self._client.send(
                request, header_parameters, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.CloudTaskPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.CloudTaskPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized

    def add_collection(
            self, job_id, value, task_add_collection_options=None, custom_headers=None, raw=False, **operation_config):
        """Adds a collection of tasks to the specified job.

        :param job_id: The id of the job to which the task collection is to
         be added.
        :type job_id: str
        :param value: The collection of tasks to add.
        :type value: list of :class:`TaskAddParameter
         <azure.batch.models.TaskAddParameter>`
        :param task_add_collection_options: Additional parameters for the
         operation
        :type task_add_collection_options: :class:`TaskAddCollectionOptions
         <azure.batch.models.TaskAddCollectionOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`TaskAddCollectionResult
         <azure.batch.models.TaskAddCollectionResult>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if task_add_collection_options is not None:
            timeout = task_add_collection_options.timeout
        client_request_id = None
        if task_add_collection_options is not None:
            client_request_id = task_add_collection_options.client_request_id
        return_client_request_id = None
        if task_add_collection_options is not None:
            return_client_request_id = task_add_collection_options.return_client_request_id
        ocp_date = None
        if task_add_collection_options is not None:
            ocp_date = task_add_collection_options.ocp_date
        task_collection = models.TaskAddCollectionParameter(value=value)

        # Construct URL
        url = '/jobs/{jobId}/addtaskcollection'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(task_collection, 'TaskAddCollectionParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('TaskAddCollectionResult', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def delete(
            self, job_id, task_id, task_delete_options=None, custom_headers=None, raw=False, **operation_config):
        """Deletes a task from the specified job.

        :param job_id: The id of the job from which to delete the task.
        :type job_id: str
        :param task_id: The id of the task to delete.
        :type task_id: str
        :param task_delete_options: Additional parameters for the operation
        :type task_delete_options: :class:`TaskDeleteOptions
         <azure.batch.models.TaskDeleteOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if task_delete_options is not None:
            timeout = task_delete_options.timeout
        client_request_id = None
        if task_delete_options is not None:
            client_request_id = task_delete_options.client_request_id
        return_client_request_id = None
        if task_delete_options is not None:
            return_client_request_id = task_delete_options.return_client_request_id
        ocp_date = None
        if task_delete_options is not None:
            ocp_date = task_delete_options.ocp_date
        if_match = None
        if task_delete_options is not None:
            if_match = task_delete_options.if_match
        if_none_match = None
        if task_delete_options is not None:
            if_none_match = task_delete_options.if_none_match
        if_modified_since = None
        if task_delete_options is not None:
            if_modified_since = task_delete_options.if_modified_since
        if_unmodified_since = None
        if task_delete_options is not None:
            if_unmodified_since = task_delete_options.if_unmodified_since

        # Construct URL
        url = '/jobs/{jobId}/tasks/{taskId}'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str'),
            'taskId': self._serialize.url("task_id", task_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
            })
            return client_raw_response

    def get(
            self, job_id, task_id, task_get_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets information about the specified task.

        :param job_id: The id of the job that contains the task.
        :type job_id: str
        :param task_id: The id of the task to get information about.
        :type task_id: str
        :param task_get_options: Additional parameters for the operation
        :type task_get_options: :class:`TaskGetOptions
         <azure.batch.models.TaskGetOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`CloudTask <azure.batch.models.CloudTask>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        select = None
        if task_get_options is not None:
            select = task_get_options.select
        expand = None
        if task_get_options is not None:
            expand = task_get_options.expand
        timeout = None
        if task_get_options is not None:
            timeout = task_get_options.timeout
        client_request_id = None
        if task_get_options is not None:
            client_request_id = task_get_options.client_request_id
        return_client_request_id = None
        if task_get_options is not None:
            return_client_request_id = task_get_options.return_client_request_id
        ocp_date = None
        if task_get_options is not None:
            ocp_date = task_get_options.ocp_date
        if_match = None
        if task_get_options is not None:
            if_match = task_get_options.if_match
        if_none_match = None
        if task_get_options is not None:
            if_none_match = task_get_options.if_none_match
        if_modified_since = None
        if task_get_options is not None:
            if_modified_since = task_get_options.if_modified_since
        if_unmodified_since = None
        if task_get_options is not None:
            if_unmodified_since = task_get_options.if_unmodified_since

        # Construct URL
        url = '/jobs/{jobId}/tasks/{taskId}'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str'),
            'taskId': self._serialize.url("task_id", task_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if expand is not None:
            query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('CloudTask', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def update(
            self, job_id, task_id, task_update_options=None, constraints=None, custom_headers=None, raw=False, **operation_config):
        """Updates the properties of the specified task.

        :param job_id: The id of the job containing the task.
        :type job_id: str
        :param task_id: The id of the task to update.
        :type task_id: str
        :param task_update_options: Additional parameters for the operation
        :type task_update_options: :class:`TaskUpdateOptions
         <azure.batch.models.TaskUpdateOptions>`
        :param constraints: Constraints that apply to this task. If omitted,
         the task is given the default constraints.
        :type constraints: :class:`TaskConstraints
         <azure.batch.models.TaskConstraints>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if task_update_options is not None:
            timeout = task_update_options.timeout
        client_request_id = None
        if task_update_options is not None:
            client_request_id = task_update_options.client_request_id
        return_client_request_id = None
        if task_update_options is not None:
            return_client_request_id = task_update_options.return_client_request_id
        ocp_date = None
        if task_update_options is not None:
            ocp_date = task_update_options.ocp_date
        if_match = None
        if task_update_options is not None:
            if_match = task_update_options.if_match
        if_none_match = None
        if task_update_options is not None:
            if_none_match = task_update_options.if_none_match
        if_modified_since = None
        if task_update_options is not None:
            if_modified_since = task_update_options.if_modified_since
        if_unmodified_since = None
        if task_update_options is not None:
            if_unmodified_since = task_update_options.if_unmodified_since
        task_update_parameter = models.TaskUpdateParameter(constraints=constraints)

        # Construct URL
        url = '/jobs/{jobId}/tasks/{taskId}'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str'),
            'taskId': self._serialize.url("task_id", task_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(task_update_parameter, 'TaskUpdateParameter')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def list_subtasks(
            self, job_id, task_id, task_list_subtasks_options=None, custom_headers=None, raw=False, **operation_config):
        """Lists all of the subtasks that are associated with the specified
        multi-instance task.

        :param job_id: The id of the job.
        :type job_id: str
        :param task_id: The id of the task.
        :type task_id: str
        :param task_list_subtasks_options: Additional parameters for the
         operation
        :type task_list_subtasks_options: :class:`TaskListSubtasksOptions
         <azure.batch.models.TaskListSubtasksOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`CloudTaskListSubtasksResult
         <azure.batch.models.CloudTaskListSubtasksResult>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        select = None
        if task_list_subtasks_options is not None:
            select = task_list_subtasks_options.select
        timeout = None
        if task_list_subtasks_options is not None:
            timeout = task_list_subtasks_options.timeout
        client_request_id = None
        if task_list_subtasks_options is not None:
            client_request_id = task_list_subtasks_options.client_request_id
        return_client_request_id = None
        if task_list_subtasks_options is not None:
            return_client_request_id = task_list_subtasks_options.return_client_request_id
        ocp_date = None
        if task_list_subtasks_options is not None:
            ocp_date = task_list_subtasks_options.ocp_date

        # Construct URL
        url = '/jobs/{jobId}/tasks/{taskId}/subtasksinfo'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str'),
            'taskId': self._serialize.url("task_id", task_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('CloudTaskListSubtasksResult', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def terminate(
            self, job_id, task_id, task_terminate_options=None, custom_headers=None, raw=False, **operation_config):
        """Terminates the specified task.

        :param job_id: The id of the job containing the task.
        :type job_id: str
        :param task_id: The id of the task to terminate.
        :type task_id: str
        :param task_terminate_options: Additional parameters for the operation
        :type task_terminate_options: :class:`TaskTerminateOptions
         <azure.batch.models.TaskTerminateOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if task_terminate_options is not None:
            timeout = task_terminate_options.timeout
        client_request_id = None
        if task_terminate_options is not None:
            client_request_id = task_terminate_options.client_request_id
        return_client_request_id = None
        if task_terminate_options is not None:
            return_client_request_id = task_terminate_options.return_client_request_id
        ocp_date = None
        if task_terminate_options is not None:
            ocp_date = task_terminate_options.ocp_date
        if_match = None
        if task_terminate_options is not None:
            if_match = task_terminate_options.if_match
        if_none_match = None
        if task_terminate_options is not None:
            if_none_match = task_terminate_options.if_none_match
        if_modified_since = None
        if task_terminate_options is not None:
            if_modified_since = task_terminate_options.if_modified_since
        if_unmodified_since = None
        if task_terminate_options is not None:
            if_unmodified_since = task_terminate_options.if_unmodified_since

        # Construct URL
        url = '/jobs/{jobId}/tasks/{taskId}/terminate'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str'),
            'taskId': self._serialize.url("task_id", task_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [204]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
