# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationPackage(Model):
    """Contains information about an application package.

    :param version: The version of the application package.
    :type version: str
    :param state: The current state of the application package. Possible
     values include: 'pending', 'active', 'unmapped'
    :type state: str or :class:`PackageState
     <azure.mgmt.batch.models.PackageState>`
    :param format: The format of the application package, if the package has
     been activated.
    :type format: str
    :param last_activation_time: The time at which the package was last
     activated, if the package is active.
    :type last_activation_time: datetime
    """ 

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'state': {'key': 'state', 'type': 'PackageState'},
        'format': {'key': 'format', 'type': 'str'},
        'last_activation_time': {'key': 'lastActivationTime', 'type': 'iso-8601'},
    }

    def __init__(self, version=None, state=None, format=None, last_activation_time=None):
        self.version = version
        self.state = state
        self.format = format
        self.last_activation_time = last_activation_time
