# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AutoStorageProperties(Model):
    """Contains information about the auto storage account associated with a
    Batch account.

    :param storage_account_id: The resource id of the storage account to be
     used for auto storage account.
    :type storage_account_id: str
    :param last_key_sync: The UTC time at which storage keys were last
     synchronized with the Batch account.
    :type last_key_sync: datetime
    """ 

    _validation = {
        'storage_account_id': {'required': True},
        'last_key_sync': {'required': True},
    }

    _attribute_map = {
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'last_key_sync': {'key': 'lastKeySync', 'type': 'iso-8601'},
    }

    def __init__(self, storage_account_id, last_key_sync):
        self.storage_account_id = storage_account_id
        self.last_key_sync = last_key_sync
