# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobConstraints(Model):
    """The execution constraints for a job.

    :param max_wall_clock_time: The maximum elapsed time that the job may run,
     measured from the time the job is created. If the job does not complete
     within the time limit, the Batch service terminates it and any tasks that
     are still running. In this case, the termination reason will be
     MaxWallClockTimeExpiry. If this property is not specified, there is no
     time limit on how long the job may run.
    :type max_wall_clock_time: timedelta
    :param max_task_retry_count: The maximum number of times each task may be
     retried. The Batch service retries a task if its exit code is nonzero.
     Note that this value specifically controls the number of retries. The
     Batch service will try each task once, and may then retry up to this
     limit. For example, if the maximum retry count is 3, Batch tries a task up
     to 4 times (one initial try and 3 retries). If the maximum retry count is
     0, the Batch service does not retry tasks. If the maximum retry count is
     -1, the Batch service retries tasks without limit. The default value is 0
     (no retries).
    :type max_task_retry_count: int
    """

    _attribute_map = {
        'max_wall_clock_time': {'key': 'maxWallClockTime', 'type': 'duration'},
        'max_task_retry_count': {'key': 'maxTaskRetryCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(JobConstraints, self).__init__(**kwargs)
        self.max_wall_clock_time = kwargs.get('max_wall_clock_time', None)
        self.max_task_retry_count = kwargs.get('max_task_retry_count', None)
