# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GroupResult(Model):
    """An array of face groups based on face similarity.

    All required parameters must be populated in order to send to Azure.

    :param groups: Required. A partition of the original faces based on face
     similarity. Groups are ranked by number of faces
    :type groups: list[list[str]]
    :param messy_group: Face ids array of faces that cannot find any similar
     faces from original faces.
    :type messy_group: list[str]
    """

    _validation = {
        'groups': {'required': True},
    }

    _attribute_map = {
        'groups': {'key': 'groups', 'type': '[[str]]'},
        'messy_group': {'key': 'messyGroup', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(GroupResult, self).__init__(**kwargs)
        self.groups = kwargs.get('groups', None)
        self.messy_group = kwargs.get('messy_group', None)
