# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class FirewallRule(SubResource):
    """Data Lake Store firewall rule information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar start_ip_address: The start IP address for the firewall rule. This
     can be either ipv4 or ipv6. Start and End should be in the same protocol.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address for the firewall rule. This can
     be either ipv4 or ipv6. Start and End should be in the same protocol.
    :vartype end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip_address': {'readonly': True},
        'end_ip_address': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FirewallRule, self).__init__(**kwargs)
        self.start_ip_address = None
        self.end_ip_address = None
