# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServerProperties(Model):
    """Server properties for Oracle, MySQL type source.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar server_platform: Name of the server platform
    :vartype server_platform: str
    :ivar server_name: Name of the server
    :vartype server_name: str
    :ivar server_version: Version of the database server
    :vartype server_version: str
    :ivar server_edition: Edition of the database server
    :vartype server_edition: str
    :ivar server_operating_system_version: Version of the operating system
    :vartype server_operating_system_version: str
    :ivar server_database_count: Number of databases in the server
    :vartype server_database_count: int
    """

    _validation = {
        'server_platform': {'readonly': True},
        'server_name': {'readonly': True},
        'server_version': {'readonly': True},
        'server_edition': {'readonly': True},
        'server_operating_system_version': {'readonly': True},
        'server_database_count': {'readonly': True},
    }

    _attribute_map = {
        'server_platform': {'key': 'serverPlatform', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'server_version': {'key': 'serverVersion', 'type': 'str'},
        'server_edition': {'key': 'serverEdition', 'type': 'str'},
        'server_operating_system_version': {'key': 'serverOperatingSystemVersion', 'type': 'str'},
        'server_database_count': {'key': 'serverDatabaseCount', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServerProperties, self).__init__(**kwargs)
        self.server_platform = None
        self.server_name = None
        self.server_version = None
        self.server_edition = None
        self.server_operating_system_version = None
        self.server_database_count = None
