/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*-
 *  vim:expandtab:shiftwidth=2:tabstop=2:smarttab:
 *
 * drizzle-interface: Interface Wrappers for Drizzle
 * Copyright (c) 2009 Sun Microsystems
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

typedef struct drizzle_query_st {} Query;

%extend Query {


  ~Query() {
    drizzle_query_free($self);
  }

  Connection *con()
  {
    return drizzle_query_con($self);
  }

  void set_con(Connection *con)
  {
    drizzle_query_set_con($self, con);
  }

  Result *buffer_result()
  {
    Result *res= drizzle_query_result($self);
    // TODO: Handle Error
    (void)drizzle_result_buffer(res);
    return res;
  }

  Result *result()
  {
    return drizzle_query_result($self);
  }

  void set_result(Result *result)
  {
    drizzle_query_set_result($self, result);
  }

  char *string(size_t *size)
  {
    return drizzle_query_string($self, size);
  }

  void set_string(const char *string, size_t size)
  {
    drizzle_query_set_string($self, string, size);
  }

  drizzle_query_options_t query_options()
  {
    return drizzle_query_options($self);
  }

  void *context()
  {
    return drizzle_query_context($self);
  }

  void set_context(void *context)
  {
    drizzle_query_set_context($self, context);
  }

}
