import _unac
#---------------------------------------------------------------------------
#
#   python-unac
#   
#   Copyright (C) Robert Kaye 2005
#   
#   This file is part of python-unac.
#
#   python-unac is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   libtunepimp is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with libtunepimp; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#---------------------------------------------------------------------------

def unac_string(text, charset=''):
    '''
    Unaccent a string. Pass in a unicode or a string object. For string objects a second
    argument that specifies the encoding of the string is required. This function
    returns an unaccented unicode or string object, depending on what was passed in.
    '''

    if text.__class__.__name__ == 'unicode':
        ret = _unac._unac_string_utf16(text.encode('utf-16-be'))
        return unicode(ret, 'utf-16-be')
    else:
        if not charset: return ""
        return _unac._unac_string(charset, text).encode(charset, 'replace')
