#ifndef VISUAL_CYLMODEL_H
#define VISUAL_CYLMODEL_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

// cyl_model.h - Generates cylinder models, which are presently used
//   to render cones as well as cylinders.  Modeled after sph_model,
//   but not nearly as weird.
#include "tmatrix.h"

namespace visual {

struct cyl_model 
{
	float* verts;
	int nverts;

	// scratch data for renderer:
	vertex* proj;
	float* color;

	static cyl_model& get(int sides);

	cyl_model(int sides);

	~cyl_model() 
	{
		delete[] verts;
		delete[] proj;
		delete[] color;
	}
};

} // !namespace visual

#endif // !VISUAL_CYLMODEL_H
