#ifndef VISUAL_PLATWIN_H
#define VISUAL_PLATWIN_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#ifdef __GNUC__  // For MinGW
// Not strictly required, it just makes preprocessing go faster.
# define WIN32_LEAN_AND_MEAN 1
// Work around conflicts between the STL and MS-defined min/max macros.
# ifndef NOMINMAX
#  define NOMINMAX 1
# endif
#endif

/* 2003-02-17 Jonathan Brandmeyer
 * We cannot #include windows.h in namespace win, because it implicitly
 * includes stdarg.h.  This causes conflicts in the Python headers due to 
 * an inability to correctly type va_list. (win::va_list works )
 * This problem has been demonstrated on MSVC6/SP5 and MinGW 2.0.0.  
 * I don't know how we got away with it before.
 */
#include <windows.h>

namespace visual {

// Note that in the past, this class was called winCritSec, and then typedef'ed to type mutex.
// Placing stuff in namespace visual removes the need for this hack.
class mutex 
{
private:
	int count;
	CRITICAL_SECTION sec;

public:
	typedef lock<mutex> lock;

	mutex(int spincount=0, int count=1);
	~mutex();

	inline void sync_lock() { EnterCriticalSection(&sec); }
	inline void count_lock() { EnterCriticalSection(&sec); count++; }
	inline void sync_unlock() { LeaveCriticalSection(&sec); }
	inline int  sync_count() { return count; }

	inline void clear() 
	{ 
		sync_lock();
		count=0;
		sync_unlock();
	}
};

void _threaded_timer(double seconds, bool (*callback)(void*), void *data);

template <class T>
void threaded_timer(double seconds, bool (*callback)(T*), T* data) 
{
  _threaded_timer(seconds, (bool(*)(void*))callback, (void*)data);
}

} // !namespace visual
  
#endif // !VISUAL_PLATWIN_H
