// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "axial.h"
#include "exceptions.h"

namespace visual {
	
void 
axialSymmetry::set_length( const double& l) 
{
	if (!axis)
		throw python::ZeroDivisionError("Degenerate primitive");
	axis = axis * (l / axis.mag());
}

void
axialSymmetry::set_radius( const double& r)
{
	write_lock L( mtx);
	radius = r;
}

vector
axialSymmetry::getScale()
{
	return vector( axis.mag()*0.5, radius, radius);
}	
	
} // !namespace visual
