// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.
#include "kbobject.h"

namespace visual {

int kbObject::get_available_keys()
{
	return keys.size();
}

std::string kbObject::pop_next_key()
{
	while (true) {
		{
			mutex::lock L(mtx);
			if (!keys.empty()) {
				std::string s = keys.front();
				keys.pop();
				return s;
			}
		}
		threaded_sleep(0.01);
		Py_MakePendingCalls();
	}	
}

void kbObject::push_new_key( std::string key)
{
	mutex::lock L(mtx);
	keys.push( key);
}

} // !namespace visual
