/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: transactionview.h 389 2006-03-10 02:20:53Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/



#ifndef KBANKING_TRANSACTIONVIEW_H
#define KBANKING_TRANSACTIONVIEW_H

#include "transactionview.ui.h"

#include <qwidget.h>
#include <qstatusbar.h>
#include <qlabel.h>


class TransactionView;
class KBanking;
class Account;


#include "txlist.h"
#include "refpointer.h"


class TransactionView: public TransactionViewUi {
  Q_OBJECT
public:
  TransactionView(Account *a,
                  bool shortList,
                  QWidget* parent=0, const char* name=0, WFlags fl=0);
  TransactionView(KBanking *app,
                  const std::list<RefPointer<Transaction> > &l,
                  const char *tname=0,
                  bool shortList=true,
                  QWidget* parent=0,
                  const char* name=0,
                  WFlags fl=0);

  ~TransactionView();

  bool init();
  bool fini();

protected:
  //void resizeEvent(QResizeEvent *e);

private:
  KBanking *_app;
  Account *_account;
  TransactionListView2Item *_currentItem;
  TransactionListView2Item *_currentContextItem;
  bool _shortList;
  const char *_tname;
  std::list<RefPointer<Transaction> > _transactions;

public slots:
  void slotUpdated();
  void slotDetails();
  void slotSetPayee();
  void slotOpenPayee();
  void slotSetCategory();
  void slotOpenCategory();
  void slotCurrentChanged(QListViewItem *item);

  void slotContextMenuRequested(QListViewItem *lvi,
                                const QPoint &coord,
                                int column);
  void slotNewTransaction();
  void slotNewEuTransaction();
  void slotNewDebitNote();
};








#endif /* KBANKING_TRANSACTIONVIEW_H */



