/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: categorylist.h 309 2005-09-05 05:13:21Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef KBANKING_CATEGORYLIST_H
#define KBANKING_CATEGORYLIST_H


#include <qlistview.h>
#include <qsimplerichtext.h>

#include <list>

#define CATEGORY_LISTVIEW_COLUMNS 3


class CategoryListView;
class CategoryListViewItem;

#include "category.h"


class CategoryListViewItem: public QListViewItem {
private:
  Category *_category;
  QSimpleRichText *_cell[CATEGORY_LISTVIEW_COLUMNS];
  int _ht;
  std::string _colour;

  void _populate();

public:
  CategoryListViewItem(CategoryListView *parent,
                       Category *cat);
  CategoryListViewItem(CategoryListViewItem *parent,
                       Category *cat);
  CategoryListViewItem(CategoryListView *parent,
                       QListViewItem *after,
                       Category *cat);
  CategoryListViewItem(const CategoryListViewItem &item);

  virtual ~CategoryListViewItem();

  Category *getCategory();

  virtual void paintCell(QPainter * p,
                         const QColorGroup & cg,
                         int column,
                         int width,
                         int align);
  virtual int width(const QFontMetrics &,
                    const QListView *,
                    int column) const;
  virtual void setup();
  virtual QString key(int column, bool ascending) const;

  void redrawItem();

  void setColour(const QString &c);

};



class CategoryListView: public QListView {
  Q_OBJECT
private:
public:
  CategoryListView(QWidget *parent=0, const char *name=0);
  virtual ~CategoryListView();

  void addCategory(Category *cat, const char *hiddenId=0);
  void addCategoryTo(Category *cat,
                     CategoryListViewItem *where,
                     const char *hiddenId);
  void addCategories(const std::list<Category*> &cats,
                     const char *hiddenId=0);

  Category *getCurrentCategory();
  std::list<Category*> getSelectedCategories();
  void selectCategory(const char *id, bool s);
  void selectSingleCategory(const char *id, bool s);

  void setCurrentCategory(const char *id);

  void expandAll();
  void ensureSelectionVisible();

  void redrawSelected();

  void updateAll();

  void beginModify();
  void endModify();
  bool isModifying();

  bool useColoursForText() const;
  void setUseColoursForText(bool b);

public slots:
  void slotHeaderChanged(int section,
                         int oldSize,
                         int newSize);

private:
  bool _needUpdate;
  bool _useColoursForText;
  int _modify;
};


#endif /* KBANKING_CATEGORYLIST_H */

