/****************************************************************************
** $Id: qt/dirview.h   3.3.4   edited May 27 2003 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
** Heavily modified by Marco Costalba
*****************************************************************************/

#ifndef TREEVIEW_H
#define TREEVIEW_H

#include <qlistview.h>
#include <qpixmap.h>
#include <qdict.h>
#include "exceptionmanager.h"
#include "common.h"

class DirItem;
class TreeView;
class Git;
class StateInfo;
class Domain;

class FileItem : public QListViewItem {
public:
	FileItem(DirItem* parent, SCRef nm) : QListViewItem((QListViewItem*)parent),
	         name(nm), p(parent), pix(0), isModified(false) {}
	FileItem(QListView* parent, SCRef nm) : QListViewItem(parent),
	         name(nm), p(0), pix(0), isModified(false) {}

	virtual QString text(int column) const;
	virtual const QPixmap *pixmap(int i) const;
	virtual QString fullName();
	virtual void paintCell(QPainter* p, const QColorGroup& cg,
	                       int column, int width, int align);

#if !defined(Q_NO_USING_KEYWORD)
	using QListViewItem::setPixmap;
#endif
	virtual void setPixmap(QPixmap* p);
	virtual void setModified(bool b) { isModified = b; }

protected:
	QString name;
	DirItem* p;
	QPixmap* pix;
	bool isModified;
};

class DirItem : public FileItem {
public:
	DirItem(QListView* parent, SCRef ts, SCRef nm, TreeView* t);
	DirItem(DirItem* parent, SCRef ts, SCRef nm, TreeView* t);

	void setOpen(bool);
	virtual void setup();

protected:
	friend class TreeView;

	QString treeSha;
	TreeView* tv;
	bool isWorkingDir;
	static QPixmap* folderClosed;
	static QPixmap* folderOpen;
};

class TreeView : public QObject {
Q_OBJECT
public:
	TreeView(Domain* d, Git* g, QListView* lv);
	void initMimePix();
	void update();
	void setTreeName(SCRef treeName);
	void setMimePix(SCRef ext, QPixmap* pix);
	QPixmap* mimePix(SCRef ext);
	const QString fullName(QListViewItem* item);
	bool isDir(SCRef fileName);
	bool isModified(SCRef path, bool isDir = false);
	void clear();
	void getTreeSelectedItems(QStringList& selectedItems);
	void getTree(SCRef treeSha, SList names,
	             SList shas, SList types, bool isWorkingDir, SCRef treePath);

signals:
	void updateViews(const QString& newRevSha, const QString& newFileName);
	void contextMenu(const QString&, int type);

protected slots:
	void on_contextMenuRequested(QListViewItem*,const QPoint&,int);
	void on_currentChanged(QListViewItem*);

private:
	void setTree(SCRef treeSha);
	void setFile(SCRef fileName);
	void restoreStuff();
	void deleteOldTree();

	EM_DECLARE(exTreeCleared);

	Domain* d;
	Git* git;
	QListView* listView;
	StateInfo* st;
	QListViewItem* oldRoot;
	QDict<QPixmap> mimePixMap;
	QString rootName;
	QStringList modifiedFiles; // no need a map, should not be a lot
	QStringList modifiedDirs;
	bool ignoreCurrentChanged;
	static QPixmap* fileDefault;
};

#endif
