/***************************************************************************
                          qgeneralconfig.h  -  description
                             -------------------
    begin                : Tue Jul 4 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGENERALCONFIG_H
#define QGENERALCONFIG_H

#include "qconfigpage.h"
#include "qgeneralconfigbase.h"

// buttons ID's
#define	ORIENT_PORTRAIT	1
#define	ORIENT_LANDSCAPE	2
#define	ORIENT_REVERSE	3
#define	ORIENT_REVPORTRAIT	4

#define	DUPLEX_NORMAL	5
#define	DUPLEX_BOOK	6
#define	DUPLEX_TABLET	7

#define	NUP_1	10
#define	NUP_2	11
#define	NUP_4	12

/**
  *@author Michael Goffioul
  */

class QGeneralConfig : public QGeneralConfigBase, public QConfigPage  {
   Q_OBJECT
public:
	QGeneralConfig(QWidget *parent=0, const char *name=0);
	~QGeneralConfig();
  /**  */
  void initOptions(int num_options, cups_option_t *options, global_ppd_file_t* ppd, ipp_t *req = 0);
  /**  */
  void getCupsOptions(int& num_options, cups_option_t **options, bool include_default = false, ipp_t *req = 0);

protected: 
  /**  */
  void initDialog();
  /**  */
  void initCombo(QComboBox *cb, ppd_file_t *ppd, const char *keyword, const QPixmap& pix);

private:
	global_ppd_file_t *ppd_;
protected slots: // Protected slots
  /**  */
  void buttonClicked(int ID);
};

#endif
