#include "qppdwidget.h"
#include "qppdview.h"
#include "qppdoptionview.h"

#include <qlayout.h>

QPPDWidget::QPPDWidget(QWidget *parent, const char *name)
	: QWidget(parent,name)
{
	ppdview_ = new QPPDView(NULL,this);
	ppdoptview_ = new QPPDOptionView(this);

	QObject::connect(ppdview_,SIGNAL(selectionChanged(QListViewItem*)),ppdoptview_,SLOT(setOption(QListViewItem*)));
	QObject::connect(ppdoptview_,SIGNAL(optionChanged()),ppdview_,SLOT(checkConstraints()));

	QVBoxLayout	*mainLayout_ = new QVBoxLayout(this, 10, 10);
	mainLayout_->addWidget(ppdview_);
	mainLayout_->addWidget(ppdoptview_);
}

QPPDWidget::~QPPDWidget()
{
}

void QPPDWidget::initialize(global_ppd_file_t *ppd, cups_dest_t *dest)
{
	ppdview_->initialize(ppd,dest);
}

void QPPDWidget::markChoices(global_ppd_file_t *ppd)
{
	ppdview_->markChoices(ppd);
}

void QPPDWidget::updateChoices(global_ppd_file_t *ppd)
{
	ppdview_->updateChoices(ppd);
	ppdoptview_->setOption(ppdview_->currentItem());
}

void QPPDWidget::getCupsOptions(int& num_options, cups_option_t **options, bool incldef)
{
	ppdview_->getCupsOptions(num_options,options,incldef);
}

void QPPDWidget::setAllowNonChangeable(bool on)
{
	ppdoptview_->setAllowNonChangeable(on);
}

bool QPPDWidget::allowNonChangeable() const
{
	return ppdoptview_->allowNonChangeable();
}

bool QPPDWidget::hasConflict()
{
        return ppdview_->hasConflict();
}
